/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.vcs.log.VcsLogHighlighter;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCommitStyleFactory {
    public static VcsLogHighlighter.VcsCommitStyle createStyle(@Nullable Color foreground, @Nullable Color background, @Nullable VcsLogHighlighter.TextStyle textStyle) {
        return new VcsCommitStyleImpl(foreground, background, textStyle);
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle foreground(@Nullable Color foreground) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(foreground, null, null);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "foreground"));
        }
        return vcsCommitStyle;
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle background(@Nullable Color background) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(null, background, null);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "background"));
        }
        return vcsCommitStyle;
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle bold() {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(null, null, VcsLogHighlighter.TextStyle.BOLD);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "bold"));
        }
        return vcsCommitStyle;
    }

    @NotNull
    public static VcsLogHighlighter.VcsCommitStyle combine(@NotNull Collection<VcsLogHighlighter.VcsCommitStyle> styles) {
        if (styles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "styles", "com/intellij/vcs/log/VcsCommitStyleFactory", "combine"));
        }
        Color foreground = null;
        Color background = null;
        VcsLogHighlighter.TextStyle textStyle = null;
        for (VcsLogHighlighter.VcsCommitStyle style : styles) {
            if (foreground == null) {
                foreground = style.getForeground();
            }
            if (background == null) {
                background = style.getBackground();
            }
            if (textStyle == null) {
                textStyle = style.getTextStyle();
            }
            if (background == null || foreground == null || textStyle == null) continue;
            break;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle(foreground, background, textStyle);
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/VcsCommitStyleFactory", "combine"));
        }
        return vcsCommitStyle;
    }

    private static class VcsCommitStyleImpl
    implements VcsLogHighlighter.VcsCommitStyle {
        @Nullable
        private final Color myForeground;
        @Nullable
        private final Color myBackground;
        @Nullable
        private final VcsLogHighlighter.TextStyle myTextStyle;

        public VcsCommitStyleImpl(@Nullable Color foreground, @Nullable Color background, @Nullable VcsLogHighlighter.TextStyle textStyle) {
            this.myForeground = foreground;
            this.myBackground = background;
            this.myTextStyle = textStyle;
        }

        @Override
        @Nullable
        public Color getForeground() {
            return this.myForeground;
        }

        @Override
        @Nullable
        public Color getBackground() {
            return this.myBackground;
        }

        @Override
        @Nullable
        public VcsLogHighlighter.TextStyle getTextStyle() {
            return this.myTextStyle;
        }
    }
}

