/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.ProjectTopics;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScriptingLibraryMappings
extends LanguagePerFileMappings<ScriptingLibraryModel>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.webcore.libraries.ScriptingLibraryMappings");
    private final Map<VirtualFile, CompoundLibrary> myCompoundLibMap;
    private CompoundLibrary myProjectLibs;
    private volatile MultiMap<String, VirtualFile> myMappingsByLibraryNameMap;

    public ScriptingLibraryMappings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "<init>"));
        }
        super(project);
        this.myCompoundLibMap = ContainerUtil.newHashMap();
        this.myProjectLibs = new CompoundLibrary();
        this.registerLibraryTableListener(new MyLibraryTableListener(), this);
        MessageBusConnection conn = project.getMessageBus().connect((Disposable)project);
        conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            @Override
            public void rootsChanged(ModuleRootEvent event) {
                ScriptingLibraryMappings.this.myMappingsByLibraryNameMap = null;
            }
        });
    }

    @NotNull
    protected abstract ScriptingLibraryManager getLibraryManager();

    public void registerLibraryTableListener(LibraryTable.Listener listener, Disposable parentDisposable) {
        LibraryTable libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        libTable.addListener(listener, parentDisposable);
        libTable = this.getLibraryManager().getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        libTable.addListener(listener, parentDisposable);
    }

    @Override
    public void setMappings(@NotNull Map<VirtualFile, ScriptingLibraryModel> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "setMappings"));
        }
        super.setMappings(mappings);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void setMapping(@Nullable VirtualFile file, @Nullable ScriptingLibraryModel dialect) {
        super.setMapping(file, dialect);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void loadState(Element state) {
        super.loadState(state);
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    public void cleanupForNextTest() {
        super.cleanupForNextTest();
        this.myMappingsByLibraryNameMap = null;
    }

    @Override
    protected String serialize(ScriptingLibraryModel library) {
        if (library instanceof CompoundLibrary) {
            return ((CompoundLibrary)library).serialize();
        }
        return this.getLibrarySerializationName(library);
    }

    @NotNull
    private String getLibrarySerializationName(@NotNull ScriptingLibraryModel library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
        }
        if (library.isPredefined()) {
            String string = this.getPredefinedLibrarySerializationName(library.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibrarySerializationName"));
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializationName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        String string = serializationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        String string = presentationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        return string;
    }

    public void reset() {
        this.getLibraryManager().reset();
        for (CompoundLibrary container : this.myCompoundLibMap.values()) {
            container.reset();
        }
        this.myProjectLibs.reset();
        this.myMappingsByLibraryNameMap = null;
    }

    public void updateMappings() {
        this.myCompoundLibMap.clear();
        this.myProjectLibs = new CompoundLibrary();
        HashMap newMappings = ContainerUtil.newHashMap();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            CompoundLibrary newContainer = new CompoundLibrary();
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                ScriptingLibraryModel updatedModel = this.getLibraryManager().getLibraryByName(libName);
                if (updatedModel == null) continue;
                newContainer.addLibrary(updatedModel);
            }
            if (newContainer.isEmpty()) continue;
            newMappings.put(file, newContainer);
            if (file == null) {
                this.myProjectLibs = newContainer;
                continue;
            }
            this.myCompoundLibMap.put(file, newContainer);
        }
        this.setMappings(newMappings);
        this.myMappingsByLibraryNameMap = null;
    }

    @NotNull
    private MultiMap<String, VirtualFile> getMappingsByLibraryNameMap() {
        MultiMap result = this.myMappingsByLibraryNameMap;
        if (result != null) {
            MultiMap multiMap = result;
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryNameMap"));
            }
            return multiMap;
        }
        result = MultiMap.create();
        Map mappings = this.getMappings();
        for (Map.Entry entry : mappings.entrySet()) {
            VirtualFile file = entry.getKey();
            CompoundLibrary container = (CompoundLibrary)ObjectUtils.tryCast(entry.getValue(), CompoundLibrary.class);
            if (container == null) continue;
            for (ScriptingLibraryModel libraryModel : container.getLibraries()) {
                String libName = libraryModel.getName();
                result.putValue((Object)libName, (Object)file);
            }
        }
        this.myMappingsByLibraryNameMap = result;
        MultiMap multiMap = result;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryNameMap"));
        }
        return multiMap;
    }

    public void associate(@Nullable VirtualFile file, String libName, boolean isPredefined) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null || !(container instanceof CompoundLibrary)) {
            container = new CompoundLibrary();
        }
        ((CompoundLibrary)container).addLibrary(libraryModel);
        this.setMapping(file, container);
        if (libraryModel.isPredefined() != isPredefined) {
            LOG.error("Library " + libName + " is incorrectly treated as " + (isPredefined ? "predefined" : "normal") + " while it is created as " + (libraryModel.isPredefined() ? "predefined" : "normal"));
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public void associateWithProject(String libName) {
        this.associate(null, libName);
    }

    public void disassociateWithProject(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "disassociateWithProject"));
        }
        this.disassociate(null, libraryName);
    }

    public void associate(@Nullable VirtualFile file, String libName) {
        this.associate(file, libName, false);
    }

    public void disassociate(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        if (container == null) {
            return;
        }
        if (container instanceof CompoundLibrary && ((CompoundLibrary)container).containsLibrary(libName)) {
            ((CompoundLibrary)container).toggleLibrary(libraryModel);
            ((CompoundLibrary)container).applyChanges();
        }
        this.myMappingsByLibraryNameMap = null;
    }

    public boolean isAssociatedWithProject(String libName) {
        return this.isAssociatedWith(null, libName);
    }

    public boolean isAssociatedWith(@Nullable VirtualFile file, String libName) {
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(file);
        return this.containsLibraryName(container, libName);
    }

    public boolean isLibraryInScopeFor(@Nullable VirtualFile file, @NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isLibraryInScopeFor"));
        }
        ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(libraryName);
        if (libraryModel == null) {
            return false;
        }
        ScriptingLibraryModel container = (ScriptingLibraryModel)this.getImmediateMapping(null);
        if (this.containsLibraryName(container, libraryName)) {
            return true;
        }
        if (file != null) {
            for (VirtualFile cur = file; cur != null; cur = cur.getParent()) {
                container = (ScriptingLibraryModel)this.getImmediateMapping(cur);
                if (!this.containsLibraryName(container, libraryName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsLibraryName(@Nullable ScriptingLibraryModel container, @NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "containsLibraryName"));
        }
        if (container == null) {
            return false;
        }
        if (container instanceof CompoundLibrary) {
            return ((CompoundLibrary)container).containsLibrary(libraryName);
        }
        return container.getName().equals(libraryName);
    }

    @Override
    @NotNull
    protected String getValueAttribute() {
        if ("libraries" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getValueAttribute"));
        }
        return "libraries";
    }

    @Override
    protected ScriptingLibraryModel handleUnknownMapping(VirtualFile file, String value) {
        if (value == null || !value.contains("{")) {
            return null;
        }
        String[] libNames = value.replace('{', ' ').replace('}', ' ').split(",");
        CompoundLibrary compoundLib = new CompoundLibrary();
        for (String libName : libNames) {
            String presentationName = this.getPredefinedLibraryPresentationName(libName.trim());
            ScriptingLibraryModel libraryModel = this.getLibraryManager().getLibraryByName(presentationName);
            if (libraryModel == null) continue;
            compoundLib.addLibrary(libraryModel);
        }
        if (file == null) {
            this.myProjectLibs = compoundLib;
        } else {
            this.myCompoundLibMap.put(file, compoundLib);
        }
        return compoundLib;
    }

    @Override
    public Collection<ScriptingLibraryModel> getAvailableValues(VirtualFile file) {
        List<ScriptingLibraryModel> libraries = this.getSingleLibraries();
        if (this.myCompoundLibMap.containsKey(file)) {
            libraries.add(this.myCompoundLibMap.get(file));
            return libraries;
        }
        CompoundLibrary compoundLib = new CompoundLibrary();
        this.myCompoundLibMap.put(file, compoundLib);
        libraries.add(compoundLib);
        return libraries;
    }

    @Override
    @Nullable
    public ScriptingLibraryModel chosenToStored(VirtualFile file, ScriptingLibraryModel value) {
        CompoundLibrary compoundLib;
        if (value instanceof CompoundLibrary) {
            return value;
        }
        CompoundLibrary compoundLibrary = compoundLib = file == null ? this.myProjectLibs : this.myCompoundLibMap.get(file);
        if (value == null) {
            if (compoundLib != null) {
                compoundLib.clearLibraries();
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        } else {
            if (compoundLib == null) {
                compoundLib = new CompoundLibrary();
                this.myCompoundLibMap.put(file, compoundLib);
            }
            compoundLib.toggleLibrary(value);
            if (compoundLib.isEmpty()) {
                this.myCompoundLibMap.remove(file);
                compoundLib = null;
            }
        }
        return compoundLib;
    }

    @Override
    public boolean isSelectable(ScriptingLibraryModel value) {
        return !(value instanceof CompoundLibrary);
    }

    @Override
    protected List<ScriptingLibraryModel> getAvailableValues() {
        return this.getSingleLibraries();
    }

    @Override
    public ScriptingLibraryModel getDefaultMapping(@Nullable VirtualFile file) {
        return null;
    }

    public List<ScriptingLibraryModel> getSingleLibraries() {
        ArrayList<ScriptingLibraryModel> libraryModels = new ArrayList<ScriptingLibraryModel>();
        libraryModels.addAll(Arrays.asList(this.getLibraryManager().getAllLibraries()));
        return libraryModels;
    }

    public void dispose() {
    }

    public static boolean isAssociatedWithProject(@NotNull List<VirtualFile> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "isAssociatedWithProject"));
        }
        return mappings.contains(null);
    }

    public boolean isApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (!this.getLibraryManager().isLibraryFile(libFile)) {
            return true;
        }
        return this.isRecursivelyApplicable(libFile, srcFile);
    }

    private boolean isRecursivelyApplicable(VirtualFile libFile, VirtualFile srcFile) {
        if (srcFile == null) {
            return false;
        }
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getMapping(srcFile);
        if (libraryModel != null && libraryModel.containsFile(libFile)) {
            return true;
        }
        return this.isApplicable(libFile, srcFile.getParent());
    }

    private static void iterateUp(@Nullable VirtualFile file, @NotNull Consumer<VirtualFile> c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "iterateUp"));
        }
        while (file != null) {
            c.consume((Object)file);
            file = file instanceof VirtualFileWindow ? ((VirtualFileWindow)((Object)file)).getDelegate() : file.getParent();
        }
        c.consume(null);
    }

    @NotNull
    public Set<VirtualFile> getLibraryFilesFor(VirtualFile file) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        ScriptingLibraryMappings.iterateUp(file, (Consumer<VirtualFile>)((Consumer)virtualFile -> {
            ScriptingLibraryModel mapping = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile);
            if (mapping != null) {
                mapping.addSignificantFiles(result);
            }
        }));
        HashSet<VirtualFile> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibraryFilesFor"));
        }
        return hashSet;
    }

    public void iterateOverAssociatedLibraries(@NotNull VirtualFile file, @NotNull Consumer<ScriptingLibraryModel> consumer) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "iterateOverAssociatedLibraries"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "iterateOverAssociatedLibraries"));
        }
        ScriptingLibraryMappings.iterateUp(file, (Consumer<VirtualFile>)((Consumer)virtualFile -> {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "lambda$iterateOverAssociatedLibraries$1"));
            }
            ScriptingLibraryModel model = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile);
            if (model != null) {
                consumer.consume((Object)model);
            }
        }));
    }

    @NotNull
    public Set<ScriptingLibraryModel> getAllLibrariesInScope(VirtualFile file) {
        HashSet<ScriptingLibraryModel> result = new HashSet<ScriptingLibraryModel>();
        ScriptingLibraryMappings.iterateUp(file, (Consumer<VirtualFile>)((Consumer)virtualFile -> {
            ScriptingLibraryModel mapping = (ScriptingLibraryModel)this.getImmediateMapping((VirtualFile)virtualFile);
            if (mapping instanceof CompoundLibrary) {
                result.addAll(((CompoundLibrary)mapping).getLibraries());
            } else if (mapping != null) {
                result.add(mapping);
            }
        }));
        HashSet<ScriptingLibraryModel> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getAllLibrariesInScope"));
        }
        return hashSet;
    }

    @Override
    protected boolean shouldReparseFiles() {
        return false;
    }

    public boolean containsProjectLibrary(String name) {
        ScriptingLibraryModel libraryModel = (ScriptingLibraryModel)this.getImmediateMapping(null);
        if (libraryModel == null) {
            return false;
        }
        if (libraryModel instanceof CompoundLibrary) {
            return ((CompoundLibrary)libraryModel).containsLibrary(name);
        }
        return libraryModel.getName().equals(name);
    }

    public boolean containsLibrary(ScriptingLibraryModel libModel) {
        String libName = libModel.getName();
        for (ScriptingLibraryModel container : this.getMappings().values()) {
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName)) continue;
            return true;
        }
        return false;
    }

    public boolean dependsOn(@NotNull Module module, @NotNull ScriptingLibraryModel libModel, int moduleCount) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "dependsOn"));
        }
        if (libModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libModel", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "dependsOn"));
        }
        String libName = libModel.getName();
        if (this.containsProjectLibrary(libName)) {
            return moduleCount == 1 || libModel.isAssociatedWith(module);
        }
        for (VirtualFile file : this.getMappings().keySet()) {
            ScriptingLibraryModel container = (ScriptingLibraryModel)this.getMapping(file);
            if (!(container instanceof CompoundLibrary) || !((CompoundLibrary)container).containsLibrary(libName) || !ModuleHelper.isSuitableModule(libModel, module, moduleCount, file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<VirtualFile> getMappingsByLibraryName(@NotNull String libraryName) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryName"));
        }
        MultiMap<String, VirtualFile> mappings = this.getMappingsByLibraryNameMap();
        List list = (List)mappings.get((Object)libraryName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getMappingsByLibraryName"));
        }
        return list;
    }

    @NotNull
    public GlobalSearchScope getLibraryScopeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibraryScopeForFile"));
        }
        Set<VirtualFile> libraryFiles = this.getLibraryFilesFor(file);
        GlobalSearchScope globalSearchScope = ScriptingLibraryUtil.getFilesAndDirectoriesScope(this.getProject(), libraryFiles);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings", "getLibraryScopeForFile"));
        }
        return globalSearchScope;
    }

    private class MyLibraryTableListener
    implements LibraryTable.Listener {
        private MyLibraryTableListener() {
        }

        @Override
        public void afterLibraryAdded(Library newLibrary) {
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void afterLibraryRenamed(Library library) {
            ScriptingLibraryMappings.this.updateMappings();
        }

        @Override
        public void beforeLibraryRemoved(Library library) {
        }

        @Override
        public void afterLibraryRemoved(Library library) {
            ScriptingLibraryMappings.this.updateMappings();
        }
    }

    public class CompoundLibrary
    extends ScriptingLibraryModel {
        private final Map<String, ScriptingLibraryModel> myLibraries;
        private final Map<String, ScriptingLibraryModel> myOldLibraries;

        public CompoundLibrary() {
            super(null, null);
            this.myLibraries = new TreeMap<String, ScriptingLibraryModel>();
            this.myOldLibraries = new TreeMap<String, ScriptingLibraryModel>();
        }

        public void clearLibraries() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
            this.myLibraries.clear();
        }

        public void toggleLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "toggleLibrary"));
            }
            String libName = library.getName();
            if (this.myLibraries.containsKey(libName)) {
                this.myLibraries.remove(libName);
                return;
            }
            this.myLibraries.put(libName, library);
        }

        private void addLibrary(@NotNull ScriptingLibraryModel library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "addLibrary"));
            }
            String libName = library.getName();
            this.myLibraries.put(libName, library);
            this.applyChanges();
        }

        public boolean containsLibrary(String libName) {
            return this.myLibraries.containsKey(libName);
        }

        @Nullable
        public String serialize() {
            ArrayList names = ContainerUtil.newArrayList();
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (this.isPredefinedLibraryWithDefaultMappingsOrIncluded(library)) continue;
                names.add(ScriptingLibraryMappings.this.getLibrarySerializationName(library));
            }
            if (names.isEmpty()) {
                return null;
            }
            return "{" + StringUtil.join((Collection)names, (String)", ") + "}";
        }

        private boolean isPredefinedLibraryWithDefaultMappingsOrIncluded(@NotNull ScriptingLibraryModel model) {
            List<VirtualFile> mappings;
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "isPredefinedLibraryWithDefaultMappingsOrIncluded"));
            }
            if (!model.isPredefined()) {
                return false;
            }
            List<VirtualFile> defaultMappings = model.getDefaultMappings();
            return defaultMappings.equals(mappings = ScriptingLibraryMappings.this.getMappingsByLibraryName(model.getName())) || defaultMappings.isEmpty() && ScriptingLibraryMappings.isAssociatedWithProject(mappings);
        }

        @Override
        @NotNull
        public String getName() {
            StringBuilder allNames = new StringBuilder();
            boolean isFirst = true;
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                allNames.append(isFirst ? "" : ", ");
                allNames.append(library.getName());
                isFirst = false;
            }
            String string = allNames.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "getName"));
            }
            return string;
        }

        @Override
        public boolean containsFile(VirtualFile file) {
            for (ScriptingLibraryModel library : this.myLibraries.values()) {
                if (!library.containsFile(file)) continue;
                return true;
            }
            return false;
        }

        public Collection<ScriptingLibraryModel> getLibraries() {
            return this.myLibraries.values();
        }

        @Override
        public boolean isEmpty() {
            return this.myLibraries.isEmpty();
        }

        public int getLibraryCount() {
            return this.myLibraries.size();
        }

        public void applyChanges() {
            this.myOldLibraries.clear();
            this.myOldLibraries.putAll(this.myLibraries);
        }

        public boolean isModified() {
            if (this.myOldLibraries == null) {
                return false;
            }
            for (String libName : this.myLibraries.keySet()) {
                if (this.myOldLibraries.containsKey(libName)) continue;
                return true;
            }
            for (String libName : ArrayUtil.toStringArray(this.myOldLibraries.keySet())) {
                if (this.myLibraries.containsKey(libName)) continue;
                return true;
            }
            return false;
        }

        public void reset() {
            this.myLibraries.clear();
            this.myLibraries.putAll(this.myOldLibraries);
        }

        @Override
        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            HashSet<VirtualFile> sourceFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                sourceFiles.addAll(libModel.getSourceFiles());
            }
            HashSet<VirtualFile> hashSet = sourceFiles;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "getSourceFiles"));
            }
            return hashSet;
        }

        @Override
        public Set<VirtualFile> getCompactFiles() {
            HashSet<VirtualFile> compactFiles = new HashSet<VirtualFile>();
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                compactFiles.addAll(libModel.getCompactFiles());
            }
            return compactFiles;
        }

        @Override
        public void addSignificantFiles(Collection<VirtualFile> result) {
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.addSignificantFiles(result);
            }
        }

        @Override
        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/webcore/libraries/ScriptingLibraryMappings$CompoundLibrary", "collectFilesWithGlobalDefinitions"));
            }
            for (ScriptingLibraryModel libModel : this.myLibraries.values()) {
                libModel.collectFilesWithGlobalDefinitions(result);
            }
        }
    }
}

