/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.spellchecker;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.spellchecker.quickfixes.AcceptWordAsCorrect;
import com.intellij.spellchecker.quickfixes.ChangeTo;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementType;

public class GherkinSpellcheckerStrategy
extends SpellcheckingStrategy {
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        ASTNode node;
        if (element instanceof LeafElement && (node = element.getNode()) != null && node.getElementType() instanceof GherkinElementType) {
            Tokenizer tokenizer = SpellcheckingStrategy.TEXT_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/spellchecker/GherkinSpellcheckerStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/spellchecker/GherkinSpellcheckerStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    public SpellCheckerQuickFix[] getRegularFixes(PsiElement element, int offset, @NotNull TextRange textRange, boolean useRename, String wordWithTypo) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "org/jetbrains/plugins/cucumber/spellchecker/GherkinSpellcheckerStrategy", "getRegularFixes"));
        }
        return new SpellCheckerQuickFix[]{new ChangeTo(wordWithTypo), new AcceptWordAsCorrect(wordWithTypo)};
    }
}

