/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.plugins.markdown.lang.MarkdownElementType;
import org.intellij.plugins.markdown.lang.parser.MarkdownParserManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownLexerAdapter
extends LexerBase {
    @NotNull
    private final MarkdownLexer delegateLexer = MarkdownParserManager.FLAVOUR.createInlinesLexer();
    private int endOffset;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/intellij/plugins/markdown/lang/lexer/MarkdownLexerAdapter", "start"));
        }
        this.endOffset = endOffset;
        this.delegateLexer.start(buffer, startOffset, endOffset);
    }

    public int getState() {
        return 1;
    }

    @Nullable
    public IElementType getTokenType() {
        return MarkdownElementType.platformType(this.delegateLexer.getType());
    }

    public int getTokenStart() {
        return this.delegateLexer.getTokenStart();
    }

    public int getTokenEnd() {
        return this.delegateLexer.getTokenEnd();
    }

    public void advance() {
        this.delegateLexer.advance();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.delegateLexer.getOriginalText();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/lexer/MarkdownLexerAdapter", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.endOffset;
    }
}

