/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.NotNull;

public class MarkdownParserManager {
    public static final GFMFlavourDescriptor FLAVOUR = new GFMFlavourDescriptor();
    private static final ThreadLocal<ParsingInfo> ourLastParsingResult = new ThreadLocal();

    public static ASTNode parseContent(@NotNull CharSequence buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager", "parseContent"));
        }
        ParsingInfo info = ourLastParsingResult.get();
        if (info != null && info.myBufferHash == buffer.hashCode() && info.myBuffer.equals(buffer)) {
            return info.myParseResult;
        }
        ASTNode parseResult = new MarkdownParser((MarkdownFlavourDescriptor)FLAVOUR).parse(MarkdownElementTypes.MARKDOWN_FILE, buffer.toString(), false);
        ourLastParsingResult.set(new ParsingInfo(buffer, parseResult));
        return parseResult;
    }

    private static class ParsingInfo {
        @NotNull
        final CharSequence myBuffer;
        final int myBufferHash;
        @NotNull
        final ASTNode myParseResult;

        public ParsingInfo(@NotNull CharSequence buffer, @NotNull ASTNode parseResult) {
            if (buffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingInfo", "<init>"));
            }
            if (parseResult == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parseResult", "org/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingInfo", "<init>"));
            }
            this.myBuffer = buffer;
            this.myBufferHash = this.myBuffer.hashCode();
            this.myParseResult = parseResult;
        }
    }
}

