/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceContentImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownCodeFenceImpl
extends CompositePsiElement
implements PsiLanguageInjectionHost,
MarkdownPsiElement {
    public MarkdownCodeFenceImpl(IElementType type) {
        super(type);
    }

    @Nullable
    public String getFenceLanguage() {
        PsiElement element = this.findPsiChildByType(MarkdownTokenTypes.FENCE_LANG);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownCodeFenceImpl.this.isValid()) {
                    return null;
                }
                return "Code fence";
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownCodeFenceImpl.this.isValid()) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (PsiElement child = MarkdownCodeFenceImpl.this.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof MarkdownCodeFenceContentImpl)) continue;
                    if (sb.length() > 0) {
                        sb.append("\\n");
                    }
                    sb.append(child.getText());
                    if (sb.length() >= 50) break;
                }
                return sb.toString();
            }
        };
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl", "updateText"));
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper<PsiLanguageInjectionHost> literalTextEscaper = new LiteralTextEscaper<PsiLanguageInjectionHost>((PsiLanguageInjectionHost)this){

            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2", "decode"));
                }
                if (outChars == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outChars", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2", "decode"));
                }
                outChars.append(rangeInsideHost.substring(this.myHost.getText()));
                return true;
            }

            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeInsideHost", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2", "getOffsetInHost"));
                }
                return rangeInsideHost.getStartOffset() + offsetInDecoded;
            }

            @NotNull
            public TextRange getRelevantTextRange() {
                TextRange textRange = this.getContentTextRange();
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$2", "getRelevantTextRange"));
                }
                return textRange;
            }

            public TextRange getContentTextRange() {
                MarkdownCodeFenceContentImpl first = (MarkdownCodeFenceContentImpl)PsiTreeUtil.findChildOfType((PsiElement)this.myHost, MarkdownCodeFenceContentImpl.class);
                if (first == null) {
                    return TextRange.EMPTY_RANGE;
                }
                MarkdownCodeFenceContentImpl last = null;
                for (PsiElement child = this.myHost.getLastChild(); child != null; child = child.getPrevSibling()) {
                    if (!(child instanceof MarkdownCodeFenceContentImpl)) continue;
                    last = (MarkdownCodeFenceContentImpl)child;
                    break;
                }
                assert (last != null);
                return TextRange.create((int)first.getStartOffsetInParent(), (int)(last.getStartOffsetInParent() + last.getTextLength()));
            }

            public boolean isOneLine() {
                return false;
            }
        };
        if (literalTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl", "createLiteralTextEscaper"));
        }
        return literalTextEscaper;
    }

    @Override
    @NotNull
    public List<MarkdownPsiElement> getCompositeChildren() {
        List<MarkdownPsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl", "getCompositeChildren"));
        }
        return list;
    }

    public static class Manipulator
    extends AbstractElementManipulator<MarkdownCodeFenceImpl> {
        public MarkdownCodeFenceImpl handleContentChange(@NotNull MarkdownCodeFenceImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$Manipulator", "handleContentChange"));
            }
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl$Manipulator", "handleContentChange"));
            }
            return null;
        }
    }
}

