/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import java.util.Arrays;
import java.util.List;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraphImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkdownCompositePsiElementBase
extends ASTWrapperPsiElement
implements MarkdownPsiElement {
    public static final int PRESENTABLE_TEXT_LENGTH = 50;

    public MarkdownCompositePsiElementBase(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCompositePsiElementBase", "<init>"));
        }
        super(node);
    }

    protected abstract String getPresentableTagName();

    @NotNull
    protected CharSequence getChars() {
        CharSequence charSequence = this.getTextRange().subSequence(this.getContainingFile().getViewProvider().getContents());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCompositePsiElementBase", "getChars"));
        }
        return charSequence;
    }

    @NotNull
    protected String shrinkTextTo(int length) {
        CharSequence chars = this.getChars();
        String string = chars.subSequence(0, Math.min(length, chars.length())).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCompositePsiElementBase", "shrinkTextTo"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<MarkdownPsiElement> getCompositeChildren() {
        List<Object> list = Arrays.asList(this.findChildrenByClass(MarkdownPsiElement.class));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCompositePsiElementBase", "getCompositeChildren"));
        }
        return list;
    }

    public boolean hasTrivialChildren() {
        List<MarkdownPsiElement> children = this.getCompositeChildren();
        if (children.size() != 1) {
            return false;
        }
        return children.iterator().next() instanceof MarkdownParagraphImpl;
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                if (!MarkdownCompositePsiElementBase.this.isValid()) {
                    return null;
                }
                return MarkdownCompositePsiElementBase.this.getPresentableTagName();
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownCompositePsiElementBase.this.isValid()) {
                    return null;
                }
                if (MarkdownCompositePsiElementBase.this.getCompositeChildren().size() == 0) {
                    return MarkdownCompositePsiElementBase.this.shrinkTextTo(50);
                }
                return null;
            }
        };
    }
}

