/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.settings;

import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.lobo.LoboHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.split.SplitFileEditor;
import org.jetbrains.annotations.NotNull;

public final class MarkdownPreviewSettings {
    public static final MarkdownPreviewSettings DEFAULT = new MarkdownPreviewSettings();
    @Attribute(value="DefaultSplitLayout")
    @NotNull
    private SplitFileEditor.SplitEditorLayout mySplitEditorLayout;
    @Tag(value="HtmlPanelProviderInfo")
    @Property(surroundWithTag=false)
    @NotNull
    private MarkdownHtmlPanelProvider.ProviderInfo myHtmlPanelProviderInfo;
    @Attribute(value="UseGrayscaleRendering")
    private boolean myUseGrayscaleRendering;

    public MarkdownPreviewSettings() {
        this.mySplitEditorLayout = SplitFileEditor.SplitEditorLayout.SPLIT;
        this.myHtmlPanelProviderInfo = LoboHtmlPanelProvider.INFO;
        this.myUseGrayscaleRendering = false;
    }

    public MarkdownPreviewSettings(@NotNull SplitFileEditor.SplitEditorLayout splitEditorLayout, @NotNull MarkdownHtmlPanelProvider.ProviderInfo htmlPanelProviderInfo, boolean useGrayscaleRendering) {
        if (splitEditorLayout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitEditorLayout", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettings", "<init>"));
        }
        if (htmlPanelProviderInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlPanelProviderInfo", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettings", "<init>"));
        }
        this.mySplitEditorLayout = SplitFileEditor.SplitEditorLayout.SPLIT;
        this.myHtmlPanelProviderInfo = LoboHtmlPanelProvider.INFO;
        this.myUseGrayscaleRendering = false;
        this.mySplitEditorLayout = splitEditorLayout;
        this.myHtmlPanelProviderInfo = htmlPanelProviderInfo;
        this.myUseGrayscaleRendering = useGrayscaleRendering;
    }

    @NotNull
    public SplitFileEditor.SplitEditorLayout getSplitEditorLayout() {
        SplitFileEditor.SplitEditorLayout splitEditorLayout = this.mySplitEditorLayout;
        if (splitEditorLayout == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettings", "getSplitEditorLayout"));
        }
        return splitEditorLayout;
    }

    @NotNull
    public MarkdownHtmlPanelProvider.ProviderInfo getHtmlPanelProviderInfo() {
        MarkdownHtmlPanelProvider.ProviderInfo providerInfo = this.myHtmlPanelProviderInfo;
        if (providerInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/settings/MarkdownPreviewSettings", "getHtmlPanelProviderInfo"));
        }
        return providerInfo;
    }

    public boolean isUseGrayscaleRendering() {
        return this.myUseGrayscaleRendering;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownPreviewSettings settings = (MarkdownPreviewSettings)o;
        if (this.myUseGrayscaleRendering != settings.myUseGrayscaleRendering) {
            return false;
        }
        if (this.mySplitEditorLayout != settings.mySplitEditorLayout) {
            return false;
        }
        return this.myHtmlPanelProviderInfo.equals(settings.myHtmlPanelProviderInfo);
    }

    public int hashCode() {
        int result = this.mySplitEditorLayout.hashCode();
        result = 31 * result + this.myHtmlPanelProviderInfo.hashCode();
        result = 31 * result + (this.myUseGrayscaleRendering ? 1 : 0);
        return result;
    }

    public static interface Holder {
        public void setMarkdownPreviewSettings(@NotNull MarkdownPreviewSettings var1);

        @NotNull
        public MarkdownPreviewSettings getMarkdownPreviewSettings();
    }
}

