/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownStructureElement
implements StructureViewTreeElement,
SortableTreeElement {
    private static final ItemPresentation DUMMY_PRESENTATION = new MarkdownBasePresentation(){

        @Nullable
        public String getPresentableText() {
            return null;
        }

        @Nullable
        public String getLocationString() {
            return null;
        }
    };
    static final TokenSet PRESENTABLE_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{MarkdownTokenTypeSets.HEADERS, TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.PARAGRAPH, MarkdownElementTypes.ORDERED_LIST, MarkdownElementTypes.UNORDERED_LIST, MarkdownElementTypes.LIST_ITEM, MarkdownElementTypes.BLOCK_QUOTE, MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.HTML_BLOCK, MarkdownElementTypes.LINK_DEFINITION, MarkdownElementTypes.TABLE, MarkdownElementTypes.TABLE_HEADER, MarkdownElementTypes.TABLE_ROW, MarkdownElementTypes.TABLE_CELL})});
    @NotNull
    private final PsiElement myElement;

    public MarkdownStructureElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "<init>"));
        }
        this.myElement = element;
    }

    public Object getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        if (this.myElement instanceof NavigationItem) {
            ((NavigationItem)this.myElement).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myElement instanceof NavigationItem && ((NavigationItem)this.myElement).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement instanceof NavigationItem && ((NavigationItem)this.myElement).canNavigateToSource();
    }

    @NotNull
    public String getAlphaSortKey() {
        String string = StringUtil.notNullize(this.myElement instanceof NavigationItem ? ((NavigationItem)this.myElement).getName() : null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getAlphaSortKey"));
        }
        return string;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation result = this.getPresentationImpl();
        if (result != null) {
            ItemPresentation itemPresentation = result;
            if (itemPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getPresentation"));
            }
            return itemPresentation;
        }
        ItemPresentation itemPresentation = DUMMY_PRESENTATION;
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getPresentation"));
        }
        return itemPresentation;
    }

    @Nullable
    private ItemPresentation getPresentationImpl() {
        if (this.myElement instanceof PsiFileImpl) {
            return ((PsiFileImpl)this.myElement).getPresentation();
        }
        if (this.myElement instanceof NavigationItem) {
            return ((NavigationItem)this.myElement).getPresentation();
        }
        return null;
    }

    @NotNull
    public TreeElement[] getChildren() {
        PsiElement parentToTraverse;
        PsiElement psiElement = parentToTraverse = this.myElement instanceof MarkdownFile ? this.myElement.getFirstChild() : this.myElement;
        if (MarkdownStructureElement.hasTrivialChild(parentToTraverse)) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<MarkdownStructureElement> result = new ArrayList<MarkdownStructureElement>();
        for (PsiElement element : parentToTraverse.getChildren()) {
            IElementType type = element.getNode().getElementType();
            if (!PRESENTABLE_TYPES.contains(type)) continue;
            result.add(new MarkdownStructureElement(element));
        }
        TreeElement[] treeElementArray = (TreeElement[])ArrayUtil.toObjectArray(result, TreeElement.class);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "getChildren"));
        }
        return treeElementArray;
    }

    public static boolean hasTrivialChild(@NotNull PsiElement parentToTraverse) {
        if (parentToTraverse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentToTraverse", "org/intellij/plugins/markdown/structureView/MarkdownStructureElement", "hasTrivialChild"));
        }
        return (parentToTraverse instanceof MarkdownListItemImpl || parentToTraverse instanceof MarkdownBlockQuoteImpl) && ((MarkdownCompositePsiElementBase)parentToTraverse).hasTrivialChildren();
    }
}

