/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Range;
import java.util.List;
import javax.swing.JComponent;
import org.intellij.markdown.html.HtmlGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;

public abstract class MarkdownHtmlPanel
implements Disposable {
    @NotNull
    public abstract JComponent getComponent();

    public abstract void setHtml(@NotNull String var1);

    public abstract void setCSS(@Nullable String var1, String ... var2);

    public abstract void render();

    public abstract void scrollToMarkdownSrcOffset(int var1);

    @Nullable
    protected static Range<Integer> nodeToSrcRange(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel", "nodeToSrcRange"));
        }
        if (!node.hasAttributes()) {
            return null;
        }
        Node attribute = node.getAttributes().getNamedItem(HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME());
        if (attribute == null) {
            return null;
        }
        List startEnd = StringUtil.split((String)attribute.getNodeValue(), (String)"..");
        if (startEnd.size() != 2) {
            return null;
        }
        return new Range((Comparable)Integer.valueOf(Integer.parseInt((String)startEnd.get(0))), (Comparable)Integer.valueOf(Integer.parseInt((String)startEnd.get(1))));
    }

    @NotNull
    protected static String getCssLines(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUris", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel", "getCssLines"));
        }
        StringBuilder result = new StringBuilder();
        for (String uri : fileUris) {
            if (uri == null) continue;
            result.append("<link rel=\"stylesheet\" href=\"").append(uri).append("\" />\n");
        }
        if (inlineCss != null) {
            result.append("<style>\n").append(inlineCss).append("\n</style>\n");
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel", "getCssLines"));
        }
        return string;
    }
}

