/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler;

import flash.localization.LocalizationManager;
import flex2.compiler.ILocalizableMessage;
import flex2.compiler.Logger;

public abstract class LoggerAdapter
implements Logger {
    public static final String ERROR_LEVEL = "Error";
    public static final String WARNING_LEVEL = "Warning";
    public static final String INFO_LEVEL = "Info";
    public static final String DEBUG_LEVEL = "Debug";
    private int myErrorCount = 0;
    private int myWarningCount = 0;

    public abstract void log(String var1, String var2, int var3, int var4, String var5);

    public int errorCount() {
        return this.myErrorCount;
    }

    public int warningCount() {
        return this.myWarningCount;
    }

    public void logInfo(String info) {
        this.log(INFO_LEVEL, null, -1, -1, info);
    }

    public void logDebug(String debug) {
        this.log(DEBUG_LEVEL, null, -1, -1, debug);
    }

    public void logWarning(String warning) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, null, -1, -1, warning);
    }

    public void logError(String error) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, null, -1, -1, error);
    }

    public void logInfo(String path, String info) {
        this.log(INFO_LEVEL, path, -1, -1, info);
    }

    public void logDebug(String path, String debug) {
        this.log(DEBUG_LEVEL, path, -1, -1, debug);
    }

    public void logWarning(String path, String warning) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, -1, -1, warning);
    }

    public void logWarning(String path, String warning, int errorCode) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, -1, -1, LoggerAdapter.prependErrorCode(errorCode, warning));
    }

    public void logError(String path, String error) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, -1, -1, error);
    }

    public void logError(String path, String error, int errorCode) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, -1, -1, LoggerAdapter.prependErrorCode(errorCode, error));
    }

    public void logInfo(String path, int line, String info) {
        this.log(INFO_LEVEL, path, line, -1, info + ", line: " + line);
    }

    public void logDebug(String path, int line, String debug) {
        this.log(DEBUG_LEVEL, path, line, -1, debug);
    }

    public void logWarning(String path, int line, String warning) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, line, -1, warning);
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, line, -1, LoggerAdapter.prependErrorCode(errorCode, warning));
    }

    public void logError(String path, int line, String error) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, line, -1, error);
    }

    public void logError(String path, int line, String error, int errorCode) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, line, -1, LoggerAdapter.prependErrorCode(errorCode, error));
    }

    public void logInfo(String path, int line, int col, String info) {
        this.log(INFO_LEVEL, path, line, col, info);
    }

    public void logDebug(String path, int line, int col, String debug) {
        this.log(DEBUG_LEVEL, path, line, col, debug);
    }

    public void logWarning(String path, int line, int col, String warning) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, line, col, warning);
    }

    public void logError(String path, int line, int col, String error) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, line, col, error);
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, line, col, LoggerAdapter.appendSource(warning, source));
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        ++this.myWarningCount;
        this.log(WARNING_LEVEL, path, line, col, LoggerAdapter.appendSource(LoggerAdapter.prependErrorCode(errorCode, warning), source));
    }

    public void logError(String path, int line, int col, String error, String source) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, line, col, LoggerAdapter.appendSource(error, source));
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        ++this.myErrorCount;
        this.log(ERROR_LEVEL, path, line, col, LoggerAdapter.appendSource(LoggerAdapter.prependErrorCode(errorCode, error), source));
    }

    public void log(ILocalizableMessage m) {
        if (WARNING_LEVEL.equals(m.getLevel())) {
            ++this.myWarningCount;
        }
        if (ERROR_LEVEL.equals(m.getLevel())) {
            ++this.myErrorCount;
        }
        this.log(m.getLevel(), m.getPath(), m.getLine(), m.getColumn(), m.toString());
    }

    public void log(ILocalizableMessage m, String source) {
        if (WARNING_LEVEL.equals(m.getLevel())) {
            ++this.myWarningCount;
        }
        if (ERROR_LEVEL.equals(m.getLevel())) {
            ++this.myErrorCount;
        }
        this.log(m.getLevel(), m.getPath(), m.getLine(), m.getColumn(), LoggerAdapter.appendSource(m.toString(), source));
    }

    public void needsCompilation(String path, String reason) {
        this.log(INFO_LEVEL, path, -1, -1, "Needs compilation, reason: " + reason);
    }

    public void includedFileUpdated(String path) {
        this.log(INFO_LEVEL, path, -1, -1, "Included file updated");
    }

    public void includedFileAffected(String path) {
        this.log(INFO_LEVEL, path, -1, -1, "Included file affected");
    }

    public void setLocalizationManager(LocalizationManager mgr) {
    }

    private static String prependErrorCode(int errorCode, String message) {
        return "Error code: " + errorCode + ": " + message;
    }

    private static String appendSource(String message, String source) {
        return message;
    }
}

