/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.compiler.flex4;

import com.intellij.flex.compiler.SdkSpecificHandler;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import flash.localization.ResourceBundleLocalizer;
import flex2.compiler.CompilerAPI;
import flex2.compiler.Logger;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.DefaultsConfigurator;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.Compc;
import flex2.tools.CompcConfiguration;
import flex2.tools.Mxmlc;
import java.io.IOException;
import macromedia.asc.util.ContextStatics;

public class Flex4Handler
extends SdkSpecificHandler {
    @Override
    public void initThreadLocals(Logger logger) {
        super.initThreadLocals(logger);
        CompilerAPI.useAS3();
        CompilerAPI.usePathResolver();
        LocalizationManager localizationManager = new LocalizationManager();
        localizationManager.addLocalizer((ILocalizer)new ResourceBundleLocalizer());
        ThreadLocalToolkit.setLocalizationManager((LocalizationManager)localizationManager);
        ThreadLocalToolkit.setLogger((Logger)logger);
    }

    @Override
    public void cleanThreadLocals() {
        CompilerAPI.removePathResolver();
        ThreadLocalToolkit.setLogger(null);
        ThreadLocalToolkit.setLocalizationManager(null);
        super.cleanThreadLocals();
    }

    @Override
    public boolean isOmitTrace(boolean isSwf, String[] params) {
        try {
            Configuration configuration = this.processConfiguration(isSwf, params);
            CompilerConfiguration cc = configuration.getCompilerConfiguration();
            return !cc.debug() && cc.omitTraceStatements();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private Configuration processConfiguration(boolean isSwf, String[] params) throws ConfigurationException, IOException {
        if (isSwf) {
            ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CommandLineConfiguration.class, CommandLineConfiguration.getAliases());
            cfgbuf.setDefaultVar("file-specs");
            DefaultsConfigurator.loadDefaults((ConfigurationBuffer)cfgbuf);
            return Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"mxmlc", (String[])params, (ConfigurationBuffer)cfgbuf, CommandLineConfiguration.class, (String)"file-specs");
        }
        ConfigurationBuffer cfgbuf = new ConfigurationBuffer(CompcConfiguration.class, CompcConfiguration.getAliases());
        cfgbuf.setDefaultVar("include-classes");
        DefaultsConfigurator.loadCompcDefaults((ConfigurationBuffer)cfgbuf);
        return Mxmlc.processConfiguration((LocalizationManager)ThreadLocalToolkit.getLocalizationManager(), (String)"compc", (String[])params, (ConfigurationBuffer)cfgbuf, CompcConfiguration.class, (String)"include-classes");
    }

    @Override
    public void setupOmitTraceOption(boolean omitTrace) {
        try {
            ContextStatics.omitTrace = omitTrace;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void compileSwf(String[] args) {
        Mxmlc.mxmlc((String[])args);
    }

    @Override
    public void compileSwc(String[] args) {
        Compc.compc((String[])args);
    }
}

