/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.UI.editorActions.completionProviders;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.coldFusion.model.CfmlUtil;
import com.intellij.coldFusion.model.psi.CfmlComponentReference;
import com.intellij.coldFusion.model.psi.CfmlTag;
import com.intellij.coldFusion.model.psi.impl.CfmlAttributeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class CfmlAttributeValuesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    CfmlAttributeValuesCompletionProvider() {
    }

    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement element;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlAttributeValuesCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/coldFusion/UI/editorActions/completionProviders/CfmlAttributeValuesCompletionProvider", "addCompletions"));
        }
        for (element = parameters.getPosition(); element != null && !(element instanceof CfmlAttributeImpl); element = element.getParent()) {
        }
        if (element == null) {
            return;
        }
        CfmlAttributeImpl attribute = (CfmlAttributeImpl)element;
        String attributeName = attribute.getFirstChild().getText();
        while (element != null && !(element instanceof CfmlTag)) {
            element = element.getParent();
        }
        if (element == null) {
            return;
        }
        CfmlTag tag = (CfmlTag)element;
        String tagName = tag.getTagName();
        String[] attributeValue = CfmlUtil.getAttributeValues(tagName, attributeName, parameters.getPosition().getProject());
        if ("type".equalsIgnoreCase(attributeName) && "cfargument".equalsIgnoreCase(tagName) || "returntype".equalsIgnoreCase(attributeName) && "cffunction".equalsIgnoreCase(tagName)) {
            Object[] objects;
            Object[] objectArray = objects = CfmlComponentReference.buildVariants(attribute.getPureAttributeValue(), element.getContainingFile(), element.getProject(), null, true);
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object o = objectArray[i];
                result.addElement((LookupElement)o);
            }
        }
        for (String s : attributeValue) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)s).withCaseSensitivity(false));
        }
    }
}

