/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.CfmlScopesInfo;
import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.coldFusion.model.psi.CfmlArgumentNameReference;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlImplicitVariable;
import com.intellij.coldFusion.model.psi.CfmlReferenceExpression;
import com.intellij.coldFusion.model.psi.CfmlScopeProvider;
import com.intellij.coldFusion.model.psi.CfmlVariable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfmlAssignmentExpression
extends CfmlCompositeElement
implements CfmlExpression {
    private AssignedVariable myAssignedVariable;
    private boolean myVariableWasInitialized;

    public CfmlAssignmentExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression", "<init>"));
        }
        super(node);
        this.myAssignedVariable = null;
        this.myVariableWasInitialized = false;
    }

    @Nullable
    private AssignedVariable createAssignedVariable() {
        CfmlReferenceExpression varElement = this.getAssignedVariableElement();
        if (varElement == null) {
            return null;
        }
        CfmlImplicitVariable var = this.getContainingFile().findImplicitVariable(varElement.getText());
        if (var != null && var.getTextRange().getStartOffset() < this.getTextRange().getStartOffset()) {
            return null;
        }
        return new AssignedVariable(this.findChildByType(CfscriptTokenTypes.VAR_KEYWORD) != null);
    }

    @Nullable
    public CfmlReferenceExpression getAssignedVariableElement() {
        if (this.getFirstChild() instanceof CfmlArgumentNameReference) {
            return (CfmlReferenceExpression)this.getFirstChild();
        }
        PsiElement element = this.findChildByType(CfmlElementTypes.REFERENCE_EXPRESSION);
        if (element == null || !(element instanceof CfmlReferenceExpression)) {
            return null;
        }
        return (CfmlReferenceExpression)element;
    }

    @Nullable
    private PsiType getAssignedVariableElementType() {
        CfmlExpression e = this.getRightHandExpr();
        return e != null ? e.getPsiType() : null;
    }

    @Nullable
    public CfmlExpression getRightHandExpr() {
        CfmlExpression[] expressions = (CfmlExpression[])this.findChildrenByClass(CfmlExpression.class);
        if (expressions.length != 2) {
            return null;
        }
        return expressions[1];
    }

    @Nullable
    public CfmlVariable getAssignedVariable() {
        if (!this.myVariableWasInitialized) {
            this.myVariableWasInitialized = true;
            this.myAssignedVariable = this.createAssignedVariable();
        }
        return this.myAssignedVariable;
    }

    @Override
    public PsiType getPsiType() {
        return this.getAssignedVariableElementType();
    }

    public class AssignedVariable
    extends RenameableFakePsiElement
    implements CfmlVariable,
    CfmlScopeProvider {
        private boolean myIsDefinition;

        public AssignedVariable(boolean isDefinition) {
            super((PsiElement)CfmlAssignmentExpression.this.getContainingFile());
            this.myIsDefinition = isDefinition;
        }

        @Nullable
        public CfmlExpression getRightHandExpr() {
            return CfmlAssignmentExpression.this.getRightHandExpr();
        }

        @NotNull
        public String getName() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getName"));
                }
                return "";
            }
            String variableName = expression.getText();
            String scopeName = this.getScopeName();
            if (scopeName != null && variableName != null && variableName.startsWith(scopeName + ".")) {
                String string = variableName.substring((scopeName + ".").length(), variableName.length());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getName"));
                }
                return string;
            }
            String string = variableName != null ? expression.getText() : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getName"));
            }
            return string;
        }

        public PsiElement setName(@NotNull @NonNls String name) throws IncorrectOperationException {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "setName"));
            }
            return this;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            assert (expression != null);
            PsiElement namedElement = expression.getReferenceNameElement();
            Object object = namedElement != null ? namedElement : this;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getNavigationElement"));
            }
            return object;
        }

        public PsiElement getParent() {
            return CfmlAssignmentExpression.this.getAssignedVariableElement();
        }

        public String getTypeName() {
            return "Unknown type";
        }

        public Icon getIcon() {
            return PlatformIcons.VARIABLE_ICON;
        }

        @Override
        public PsiType getPsiType() {
            return CfmlAssignmentExpression.this.getAssignedVariableElementType();
        }

        public CfmlExpression getRightChildExpression() {
            CfmlExpression[] expressions = (CfmlExpression[])this.findChildrenByClass(CfmlExpression.class);
            if (expressions.length != 2) {
                return null;
            }
            return expressions[1];
        }

        public String toString() {
            return "AssignedVariable " + this.getName();
        }

        @Nullable
        private String getScopeName() {
            PsiElement scope;
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression != null && (scope = expression.getScope()) != null) {
                return scope.getText();
            }
            return null;
        }

        @Override
        public int getProvidedScope() {
            return CfmlScopesInfo.getScopeByString(this.getScopeName());
        }

        @Override
        public boolean isTrulyDeclaration() {
            return this.myIsDefinition;
        }

        public PsiElement getNameIdentifier() {
            return this.getNavigationElement();
        }

        @Override
        @NotNull
        public String getlookUpString() {
            CfmlReferenceExpression expression = CfmlAssignmentExpression.this.getAssignedVariableElement();
            if (expression == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getlookUpString"));
                }
                return "";
            }
            String string = expression.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlAssignmentExpression$AssignedVariable", "getlookUpString"));
            }
            return string;
        }
    }
}

