/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlPsiUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CfmlExpressionTypeCalculator {
    public static final CfmlExpressionTypeCalculator PLUS_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$1", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$1", "calculateBinary"));
            }
            PsiType rightType = rightOperand.getPsiType();
            if (rightType == null || rightType.equalsToText("java.lang.String")) {
                return rightType;
            }
            PsiType leftType = leftOperand.getPsiType();
            if (leftType == null || leftType.equalsToText("java.lang.String")) {
                return leftType;
            }
            return CfmlExpressionTypeCalculator.checkAndReturnNumeric(leftOperand, rightOperand);
        }
    };
    public static final CfmlExpressionTypeCalculator MINUS_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateUnary(@NotNull CfmlExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$2", "calculateUnary"));
            }
            PsiType type = operand.getPsiType();
            return type != null && TypeConversionUtil.isNumericType((PsiType)type) ? type : null;
        }
    };
    public static final CfmlExpressionTypeCalculator MULTIPLICATIVE_CALCULATOR = new CfmlExpressionTypeCalculator(){};
    public static final CfmlExpressionTypeCalculator CONCATINATION_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$4", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$4", "calculateBinary"));
            }
            return CfmlPsiUtil.getTypeByName("java.lang.String", leftOperand.getProject());
        }
    };
    public static final CfmlExpressionTypeCalculator BOOLEAN_CALCULATOR = new CfmlExpressionTypeCalculator(){

        @Override
        public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
            if (leftOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$5", "calculateBinary"));
            }
            if (rightOperand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$5", "calculateBinary"));
            }
            return PsiType.BOOLEAN;
        }

        @Override
        public PsiType calculateUnary(@NotNull CfmlExpression operand) {
            if (operand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator$5", "calculateUnary"));
            }
            return PsiType.BOOLEAN;
        }
    };

    private CfmlExpressionTypeCalculator() {
    }

    @Nullable
    public PsiType calculateBinary(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
        if (leftOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator", "calculateBinary"));
        }
        if (rightOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator", "calculateBinary"));
        }
        return CfmlExpressionTypeCalculator.checkAndReturnNumeric(leftOperand, rightOperand);
    }

    @Nullable
    public PsiType calculateUnary(@NotNull CfmlExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator", "calculateUnary"));
        }
        throw new AssertionError(this);
    }

    @Nullable
    private static PsiType checkAndReturnNumeric(@NotNull CfmlExpression leftOperand, @NotNull CfmlExpression rightOperand) {
        if (leftOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator", "checkAndReturnNumeric"));
        }
        if (rightOperand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightOperand", "com/intellij/coldFusion/model/psi/CfmlExpressionTypeCalculator", "checkAndReturnNumeric"));
        }
        PsiType rightType = rightOperand.getPsiType();
        if (rightType == null) {
            return null;
        }
        PsiType leftType = leftOperand.getPsiType();
        if (leftType == null) {
            return null;
        }
        if (TypeConversionUtil.isNumericType((PsiType)leftType) && TypeConversionUtil.isNumericType((PsiType)rightType)) {
            PsiClassType boxedType = ((PsiPrimitiveType)TypeConversionUtil.unboxAndBalanceTypes((PsiType)leftType, (PsiType)rightType)).getBoxedType(leftOperand.getManager(), leftOperand.getResolveScope());
            return boxedType;
        }
        return null;
    }
}

