/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.files.CfmlFile;
import com.intellij.coldFusion.model.lexer.CfmlLexer;
import com.intellij.coldFusion.model.lexer.CfmlTokenTypes;
import com.intellij.coldFusion.model.parsers.CfmlElementTypes;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.HtmlHighlightingLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import org.jetbrains.annotations.NotNull;

public class CfmlIndexPatternBuilder
implements IndexPatternBuilder {
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/model/psi/CfmlIndexPatternBuilder", "getIndexingLexer"));
        }
        if (file instanceof CfmlFile) {
            Project project = file.getProject();
            SqlLanguageDialect dialect = SqlDialectMappings.getMapping((Project)project, (VirtualFile)file.getVirtualFile());
            Lexer sqlLexer = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect)).createLexer(project);
            LayeredLexer cfmlLayeredLexer = new LayeredLexer((Lexer)new CfmlLexer(true, project));
            cfmlLayeredLexer.registerLayer((Lexer)new HtmlHighlightingLexer(), new IElementType[]{CfmlElementTypes.TEMPLATE_TEXT});
            cfmlLayeredLexer.registerLayer(sqlLexer, new IElementType[]{CfmlElementTypes.SQL});
            return cfmlLayeredLexer;
        }
        return null;
    }

    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/coldFusion/model/psi/CfmlIndexPatternBuilder", "getCommentTokenSet"));
        }
        if (file instanceof CfmlFile) {
            return CfmlTokenTypes.tsCOMMENTS;
        }
        return null;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        return 0;
    }
}

