/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coldFusion.model.psi;

import com.intellij.coldFusion.model.lexer.CfscriptTokenTypes;
import com.intellij.coldFusion.model.psi.CfmlCompositeElement;
import com.intellij.coldFusion.model.psi.CfmlExpression;
import com.intellij.coldFusion.model.psi.CfmlExpressionTypeCalculator;
import com.intellij.coldFusion.model.psi.CfmlOperatorTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CfmlOperatorExpression
extends CfmlCompositeElement
implements CfmlExpression {
    private final boolean myBinary;

    public CfmlOperatorExpression(@NotNull ASTNode node, boolean binary) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/coldFusion/model/psi/CfmlOperatorExpression", "<init>"));
        }
        super(node);
        this.myBinary = binary;
    }

    @Override
    public PsiType getPsiType() {
        CfmlExpressionTypeCalculator typeCalculator = this.getOperationSign().getTypeCalculator();
        CfmlExpression operand1 = this.getOperand1();
        if (operand1 == null) {
            return null;
        }
        if (!this.myBinary) {
            return typeCalculator.calculateUnary(operand1);
        }
        CfmlExpression operand2 = this.getOperand2();
        if (operand2 == null) {
            return null;
        }
        return typeCalculator.calculateBinary(operand1, operand2);
    }

    @NotNull
    private CfmlOperatorTokenType getOperationSign() {
        ASTNode operationNode = this.getNode().findChildByType(CfscriptTokenTypes.OPERATIONS);
        assert (operationNode != null) : this.getText();
        IElementType tokenType = operationNode.getElementType();
        assert (tokenType instanceof CfmlOperatorTokenType) : this.getText();
        CfmlOperatorTokenType cfmlOperatorTokenType = (CfmlOperatorTokenType)tokenType;
        if (cfmlOperatorTokenType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coldFusion/model/psi/CfmlOperatorExpression", "getOperationSign"));
        }
        return cfmlOperatorTokenType;
    }

    private CfmlExpression getOperand1() {
        return (CfmlExpression)this.findChildByClass(CfmlExpression.class);
    }

    private CfmlExpression getOperand2() {
        PsiElement second;
        CfmlExpression first = this.getOperand1();
        if (first == null) {
            return null;
        }
        for (second = first.getNextSibling(); second != null && !(second instanceof CfmlExpression); second = second.getNextSibling()) {
        }
        return (CfmlExpression)second;
    }
}

