/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.browserConnection.BrowserConnector;
import com.intellij.javascript.debugger.browserConnection.BrowserQualifier;
import com.intellij.javascript.debugger.browserConnection.WebBrowserConnectorBundle;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.debugger.wip.ChromeExtensionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ChromeConnector
extends BrowserConnector {
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Browser Connection", NotificationDisplayType.STICKY_BALLOON, true);
    private final SingletonNotificationManager notification = new SingletonNotificationManager(NOTIFICATION_GROUP, NotificationType.INFORMATION, null);

    ChromeConnector() {
    }

    public boolean canHandle(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserQualifier", "com/jetbrains/debugger/wip/ChromeConnector", "canHandle"));
        }
        return !browserQualifier.equals((Object)BrowserQualifier.FIREFOX);
    }

    @NotNull
    public Promise<?> ensureExtensionInstalled(@NotNull WebBrowser browser, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/debugger/wip/ChromeConnector", "ensureExtensionInstalled"));
        }
        if (ChromeExtensionUtil.isChromeRunning(browser)) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.extension.required.title", (Object[])new Object[]{browser.getName()}), WebBrowserConnectorBundle.message((String)"chrome.extension.required", (Object[])new Object[]{browser.getName()}), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
        Promise promise2 = Promises.resolvedPromise();
        if (promise2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/wip/ChromeConnector", "ensureExtensionInstalled"));
        }
        return promise2;
    }

    public void checkVersion(@NotNull WebBrowser browser, @Nullable String version, @Nullable Project project) {
        if (browser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/debugger/wip/ChromeConnector", "checkVersion"));
        }
        if (StringUtil.compareVersionNumbers((String)version, (String)"0.5") < 0) {
            this.notification.notify(WebBrowserConnectorBundle.message((String)"chrome.update.extension.title", (Object[])new Object[0]), WebBrowserConnectorBundle.message((String)"chrome.update.extension.0.4", (Object[])new Object[0]), project, (NotificationListener)new ChromeExtensionUtil.ExtLinkListener(browser, project));
        }
    }
}

