/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsolePrinter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0000\u00a8\u0006\u000b"}, d2={"printStackTrace", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "stackTrace", "", "Lorg/jetbrains/wip/protocol/runtime/CallFrameValue;", "ChromeConnector"})
public final class WipConsoleAPICalledKt {
    public static final void printStackTrace(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer, @NotNull ConsoleViewContentType contentType, @Nullable List<? extends CallFrameValue> stackTrace) {
        Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (stackTrace == null) {
            return;
        }
        if (stackTrace.isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first(stackTrace)).url())) {
            return;
        }
        printer.indentIn();
        for (CallFrameValue callFrameValue : stackTrace) {
            printer.printIndent();
            CharSequence charSequence = callFrameValue.functionName();
            ConsoleView consoleView2 = consoleView;
            boolean bl = charSequence == null || charSequence.length() == 0;
            consoleView2.print(bl ? "(anonymous function)" : callFrameValue.functionName(), contentType);
            consoleView.print("\t", contentType);
            printer.printFileLink(callFrameValue.scriptId(), callFrameValue.url(), callFrameValue.getLineNumber() - 1, callFrameValue.getColumnNumber(), callFrameValue.functionName());
            printer.newLine();
        }
        printer.indentOut();
    }
}

