/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.ConsoleMessage;
import com.intellij.javascript.debugger.ConsolePrinter;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.debugger.wip.WipConsoleMessageTask$WhenMappings;
import com.jetbrains.debugger.wip.WipConsoleMessageTaskKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.console.ConsoleMessageValue;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/debugger/wip/WipConsoleMessageTask;", "Lcom/intellij/javascript/debugger/ConsoleMessage;", "message", "Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;", "request", "Lorg/jetbrains/wip/RequestInfo;", "(Lorg/jetbrains/wip/protocol/console/ConsoleMessageValue;Lorg/jetbrains/wip/RequestInfo;)V", "print", "", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "printer", "Lcom/intellij/javascript/debugger/ConsolePrinter;", "printFailedNetworkRequestMessage", "printParameters", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "isNotFirst", "", "ChromeConnector"})
public final class WipConsoleMessageTask
implements ConsoleMessage {
    private final ConsoleMessageValue message;
    private final RequestInfo request;

    /*
     * Unable to fully structure code
     */
    public void print(@NotNull ConsoleView consoleView, @NotNull ConsolePrinter printer) {
        block28: {
            Intrinsics.checkParameterIsNotNull((Object)consoleView, (String)"consoleView");
            Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
            url = this.message.getUrl();
            line = this.message.getLine();
            column = this.message.getColumn();
            v0 = this.message.getStack();
            stackTrace = v0 != null ? v0.callFrames() : null;
            contentType = Intrinsics.areEqual((Object)this.message.level(), (Object)ConsoleMessageValue.Level.ERROR) != false ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT;
            block0 : switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$1[this.message.source().ordinal()]) {
                case 1: {
                    if (this.request == null) {
                        ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                        v1 = this.message.getUrl();
                        if (v1 == null) {
                            Intrinsics.throwNpe();
                        }
                        printer.addFileLink(v1, -1, -1, (String)null, false);
                        break;
                    }
                    if (this.request.getInitiator() != null) {
                        v2 = this.request.getInitiator();
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        v3 = v2.getStack();
                        stackTrace = v3 != null ? v3.callFrames() : null;
                        v4 = this.request.getInitiator();
                        if (v4 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (!StringUtil.isEmpty((String)v4.getUrl())) {
                            v5 = this.request.getInitiator();
                            if (v5 == null) {
                                Intrinsics.throwNpe();
                            }
                            url = v5.getUrl();
                            v6 = this.request.getInitiator();
                            if (v6 == null) {
                                Intrinsics.throwNpe();
                            }
                            line = (int)v6.getLineNumber();
                            column = -1;
                        }
                    }
                    if (Intrinsics.areEqual((Object)this.message.level(), (Object)ConsoleMessageValue.Level.ERROR)) {
                        this.printFailedNetworkRequestMessage(printer);
                        break;
                    }
                    ConsolePrinter.append$default((ConsolePrinter)printer, (String)this.message.text(), null, (int)2, null);
                    break;
                }
                default: {
                    v7 = this.message.getType();
                    if (v7 != null) {
                        switch (WipConsoleMessageTask$WhenMappings.$EnumSwitchMapping$0[v7.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (Intrinsics.areEqual((Object)this.message.getType(), (Object)ConsoleMessageValue.Type.END_GROUP)) {
                                    printer.groupEnd();
                                } else {
                                    printer.groupStart();
                                }
                                v8 = contentType;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"contentType");
                                this.printParameters(printer, v8, false);
                                break block0;
                            }
                            case 4: 
                            case 5: {
                                return;
                            }
                            case 6: {
                                printer.clear();
                                v9 = ConsoleViewContentType.getConsoleViewType((Key)ConsolePrinter.Companion.getCONSOLE_INFO_KEY());
                                Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"ConsoleViewContentType.g\u2026Printer.CONSOLE_INFO_KEY)");
                                printer.append("Console was cleared", v9);
                                break block0;
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)this.message.getType(), (Object)ConsoleMessageValue.Type.ASSERT)) {
                        v10 = contentType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"contentType");
                        printer.append("Assertion failed:", v10);
                        v11 = contentType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"contentType");
                        this.printParameters(printer, v11, true);
                        break;
                    }
                    if (!UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
                        v12 = contentType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"contentType");
                        this.printParameters(printer, v12, false);
                        break;
                    }
                    v13 = this.message.text();
                    v14 = contentType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"contentType");
                    printer.append(v13, v14);
                }
            }
            isFromNetwork = Intrinsics.areEqual((Object)this.message.source(), (Object)ConsoleMessageValue.Source.NETWORK);
            if (isFromNetwork && this.request == null) break block28;
            v15 = stackTrace;
            v16 = callFrame = v15 != null ? (CallFrameValue)CollectionsKt.firstOrNull(v15) : null;
            if (callFrame == null) ** GOTO lbl-1000
            var10_10 = callFrame.url();
            if (!(var10_10 == null || var10_10.length() == 0) && Intrinsics.areEqual((Object)callFrame.url(), (Object)"undefined") ^ true) {
                printer.addFileLink(callFrame.url(), callFrame.getLineNumber() - 1, callFrame.getColumnNumber(), callFrame.functionName(), isFromNetwork == false);
            } else lbl-1000:
            // 2 sources

            {
                var10_10 = url;
                if (!(var10_10 == null || var10_10.length() == 0) && Intrinsics.areEqual((Object)url, (Object)"undefined") ^ true) {
                    v17 = url;
                    if (v17 == null) {
                        Intrinsics.throwNpe();
                    }
                    printer.addFileLink(v17, line - 1, column, (String)null, isFromNetwork == false);
                }
            }
        }
        printer.newLine();
        if (!ContainerUtil.isEmpty((Collection)stackTrace) && (Intrinsics.areEqual((Object)this.message.source(), (Object)ConsoleMessageValue.Source.NETWORK) || Intrinsics.areEqual((Object)this.message.level(), (Object)ConsoleMessageValue.Level.ERROR) || Intrinsics.areEqual((Object)this.message.getType(), (Object)ConsoleMessageValue.Type.TRACE))) {
            v18 = contentType;
            Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"contentType");
            v19 = stackTrace;
            if (v19 == null) {
                Intrinsics.throwNpe();
            }
            WipConsoleMessageTaskKt.access$printStackTrace(consoleView, printer, v18, v19);
        }
    }

    private final void printFailedNetworkRequestMessage(ConsolePrinter printer) {
        RequestInfo requestInfo = this.request;
        if (requestInfo == null) {
            Intrinsics.throwNpe();
        }
        printer.appendError(requestInfo.getValue().method());
        printer.appendError(" ");
        printer.printBrowserLink(this.request.getValue().url());
        printer.appendError(" ");
        if (this.request.isFailed()) {
            String string = this.request.getFailDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.appendError(string);
        } else {
            printer.appendError(String.valueOf(this.request.getStatusCode()));
            if (!StringUtil.isEmpty((String)this.request.getStatusText())) {
                printer.appendError(" (");
                String string = this.request.getStatusText();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                printer.appendError(string);
                printer.appendError(")");
            }
        }
    }

    private final void printParameters(ConsolePrinter printer, ConsoleViewContentType contentType, boolean isNotFirst) {
        boolean isNotFirst2 = isNotFirst;
        if (UtilKt.isNullOrEmpty((Collection)this.message.getParameters())) {
            return;
        }
        JavaScriptDebugProcess debugProcess = printer.getDebugProcess();
        Vm vm = debugProcess.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        EvaluateContext evaluateContext2 = vm.getEvaluateContext();
        if (evaluateContext2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.EvaluateContextBase<*>");
        }
        ValueManager valueManager = ((EvaluateContextBase)evaluateContext2).getValueManager();
        if (valueManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.wip.WipValueManager");
        }
        WipValueManager valueManager2 = (WipValueManager)valueManager;
        List<RemoteObjectValue> list = this.message.getParameters();
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (RemoteObjectValue objectValue : list) {
            if (isNotFirst2) {
                printer.append(" ", contentType);
            } else {
                isNotFirst2 = true;
            }
            CharSequence charSequence = objectValue.getObjectId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                GlobalEvaluator globalEvaluator = debugProcess.getGlobalEvaluator();
                Value value = valueManager2.createValue(objectValue);
                if (value == null) {
                    Intrinsics.throwNpe();
                }
                globalEvaluator.printAndStoreValueToInspect(value, (String)null, contentType);
                continue;
            }
            if (objectValue.value() != null) {
                printer.append(String.valueOf(objectValue.value()), contentType);
                continue;
            }
            if (StringUtil.isEmpty((String)objectValue.getDescription())) continue;
            String string = objectValue.getDescription();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            printer.append(string, contentType);
        }
    }

    public WipConsoleMessageTask(@NotNull ConsoleMessageValue message, @Nullable RequestInfo request) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.message = message;
        this.request = request;
    }
}

