/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJsDebugProcess;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditor;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProcessState;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebuggableRunConfiguration;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\"\u001a\u00020#H\u0016J*\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\u000b\u0010.\u001a\u00070\t\u00a2\u0006\u0002\b/J\b\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u00106\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u000108H\u0016J\u0012\u00109\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u000108H\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000b\"\u0004\b \u0010!\u00a8\u0006:"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jetbrains/debugger/DebuggableRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "effectiveWorkingDirectory", "", "getEffectiveWorkingDirectory", "()Ljava/lang/String;", "nodePath", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "getNodePath", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;", "setNodePath", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRef;)V", "platform", "Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "getPlatform", "()Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;", "setPlatform", "(Lcom/jetbrains/plugins/reactnative/ReactNativePlatform;)V", "reactNativePackage", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "getReactNativePackage", "()Lcom/intellij/javascript/nodejs/util/NodePackage;", "setReactNativePackage", "(Lcom/intellij/javascript/nodejs/util/NodePackage;)V", "workingDirectory", "getWorkingDirectory", "setWorkingDirectory", "(Ljava/lang/String;)V", "checkConfiguration", "", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "socketAddress", "Ljava/net/InetSocketAddress;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "findWorkingDirectory", "Lorg/jetbrains/annotations/NotNull;", "getConfigurationEditor", "Lcom/jetbrains/plugins/reactnative/ReactNativeConfigurationEditor;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "ChromeConnector"})
public final class ReactNativeRunConfiguration
extends LocatableConfigurationBase
implements DebuggableRunConfiguration {
    @NotNull
    private String workingDirectory;
    @Nullable
    private NodePackage reactNativePackage;
    @NotNull
    private NodeJsInterpreterRef nodePath;
    @NotNull
    private ReactNativePlatform platform;

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    @Nullable
    public final NodePackage getReactNativePackage() {
        return this.reactNativePackage;
    }

    public final void setReactNativePackage(@Nullable NodePackage nodePackage) {
        this.reactNativePackage = nodePackage;
    }

    @NotNull
    public final NodeJsInterpreterRef getNodePath() {
        return this.nodePath;
    }

    public final void setNodePath(@NotNull NodeJsInterpreterRef nodeJsInterpreterRef) {
        Intrinsics.checkParameterIsNotNull((Object)nodeJsInterpreterRef, (String)"<set-?>");
        this.nodePath = nodeJsInterpreterRef;
    }

    @NotNull
    public final ReactNativePlatform getPlatform() {
        return this.platform;
    }

    public final void setPlatform(@NotNull ReactNativePlatform reactNativePlatform) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)reactNativePlatform), (String)"<set-?>");
        this.platform = reactNativePlatform;
    }

    @NotNull
    public final String getEffectiveWorkingDirectory() {
        String string;
        CharSequence charSequence = this.workingDirectory;
        if (charSequence.length() == 0) {
            String string2 = this.findWorkingDirectory();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"findWorkingDirectory()");
        } else {
            string = this.workingDirectory;
        }
        return string;
    }

    @NotNull
    public final String findWorkingDirectory() {
        return StringUtil.notNullize((String)this.getProject().getBasePath());
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session2, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        RemoteVmConnection connection = NodeDebugProgramRunnerKt.createRemoteConnection$default(null, 1, null);
        NodeJsDebugProcess process2 = new NodeJsDebugProcess(session2, (VmConnection<Vm>)((VmConnection)connection), (DebuggableFileFinder)new LocalFileSystemFileFinder(true), true, executionResult);
        RemoteVmConnection.open$default((RemoteVmConnection)connection, (InetSocketAddress)socketAddress, null, (int)2, null);
        return (XDebugProcess)process2;
    }

    @NotNull
    public ReactNativeConfigurationEditor getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new ReactNativeConfigurationEditor(project);
    }

    @NotNull
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return new ReactNativeProcessState(this, environment);
    }

    public void checkConfiguration() {
        NodePackage reactNative;
        block5: {
            block4: {
                super.checkConfiguration();
                NodeJsInterpreter interpreter = this.nodePath.resolve(this.getProject());
                NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
                reactNative = this.reactNativePackage;
                if (reactNative == null) break block4;
                CharSequence charSequence = reactNative.getSystemDependentPath();
                if (!(charSequence.length() == 0)) break block5;
            }
            throw (Throwable)new RuntimeConfigurationException("react-native is not specified");
        }
        if (!reactNative.isValid()) {
            throw (Throwable)new RuntimeConfigurationException("invalid react-native");
        }
    }

    public void writeExternal(@Nullable Element element) {
        super.writeExternal(element);
        if (element == null) {
            return;
        }
        CharSequence charSequence = this.workingDirectory;
        if (!(charSequence.length() == 0)) {
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p(), (String)this.workingDirectory);
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p(), (String)this.nodePath.getReferenceName());
        if (this.reactNativePackage != null) {
            NodePackage nodePackage = this.reactNativePackage;
            JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p(), (String)(nodePackage != null ? nodePackage.getSystemIndependentPath() : null));
        }
        JDOMExternalizerUtil.addElementWithValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p(), (String)this.platform.name());
    }

    public void readExternal(@Nullable Element element) {
        String platformTag;
        String reactNativeTag;
        String interpreterRefName;
        super.readExternal(element);
        if (element == null) {
            return;
        }
        String workingDir = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getWORKING_DIR_TAG$p());
        if (workingDir != null) {
            this.workingDirectory = workingDir;
        }
        if ((interpreterRefName = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getNODE_INTERPRETER_TAG$p())) != null) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create((String)interpreterRefName);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.create(interpreterRefName)");
            this.nodePath = nodeJsInterpreterRef;
        }
        if ((reactNativeTag = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getREACT_NATIVE_TAG$p())) != null) {
            this.reactNativePackage = new NodePackage(reactNativeTag);
        }
        if ((platformTag = JDOMExternalizerUtil.getFirstChildValueAttribute((Element)element, (String)ReactNativeRunConfigurationKt.access$getPLATFORM_TAG$p())) != null) {
            this.platform = ReactNativePlatform.valueOf(platformTag);
        }
    }

    public ReactNativeRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(project, factory, "");
        this.workingDirectory = "";
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterRef, (String)"NodeJsInterpreterRef.createProjectRef()");
        this.nodePath = nodeJsInterpreterRef;
        this.platform = ReactNativePlatform.ANDROID;
    }
}

