/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.io.MessageDecoder;

final class V8MessageDecoder
extends MessageDecoder {
    private static final String V8_VERSION = "V8-Version";
    private static final String EMBEDDING_HOST = "Embedding-Host";
    static final String CONTENT_LENGTH = "Content-Length";
    private static final String IGNORED = "<ignored>";
    public String v8Version;
    public String embeddingHost;
    private String name;
    private State state;
    private Consumer<V8MessageDecoder> v8VmVersionConsumer;
    private final Consumer<CharSequence> messageConsumer;
    private final MessagingLogger debugMessageQueue;

    public V8MessageDecoder(@NotNull Consumer<V8MessageDecoder> v8VmVersionConsumer, @NotNull Consumer<CharSequence> messageConsumer, @Nullable MessagingLogger debugMessageQueue) {
        if (v8VmVersionConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v8VmVersionConsumer", "org/jetbrains/v8/V8MessageDecoder", "<init>"));
        }
        if (messageConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageConsumer", "org/jetbrains/v8/V8MessageDecoder", "<init>"));
        }
        this.state = State.BEGIN_HEADER_NAME;
        this.v8VmVersionConsumer = v8VmVersionConsumer;
        this.messageConsumer = messageConsumer;
        this.debugMessageQueue = debugMessageQueue;
    }

    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/v8/V8MessageDecoder", "messageReceived"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/v8/V8MessageDecoder", "messageReceived"));
        }
        block5: while (true) {
            switch (this.state) {
                case BEGIN_HEADER_NAME: {
                    if (!this.readName(input, this.builder)) {
                        return;
                    }
                    if (this.state != State.BEGIN_HEADER_NAME) continue block5;
                    this.name = this.v8Version == null && StringUtil.equals((CharSequence)this.builder, (CharSequence)V8_VERSION) ? V8_VERSION : (this.embeddingHost == null && StringUtil.equals((CharSequence)this.builder, (CharSequence)EMBEDDING_HOST) ? EMBEDDING_HOST : (StringUtil.equals((CharSequence)this.builder, (CharSequence)CONTENT_LENGTH) ? CONTENT_LENGTH : (this.debugMessageQueue == null ? IGNORED : this.builder.toString())));
                    this.builder.setLength(0);
                    this.state = State.BEGIN_HEADER_VALUE;
                }
                case BEGIN_HEADER_VALUE: {
                    if (!V8MessageDecoder.readValue(input, this.name == IGNORED ? null : this.builder)) {
                        return;
                    }
                    if (this.debugMessageQueue != null && this.name != CONTENT_LENGTH) {
                        this.debugMessageQueue.add((CharSequence)("{\"" + this.name + '\"' + ": \"" + this.builder + "\"}"), "V8 field");
                    }
                    if (this.name == CONTENT_LENGTH) {
                        this.contentLength = this.parseContentLength();
                    } else if (this.name == V8_VERSION) {
                        this.v8Version = this.builder.toString();
                    } else if (this.name == EMBEDDING_HOST) {
                        this.embeddingHost = this.builder.toString();
                    }
                    this.builder.setLength(0);
                    this.state = State.BEGIN_HEADER_NAME;
                    this.name = null;
                    break;
                }
                case BEGIN_CONTENT: {
                    if (this.contentLength == 0) {
                        this.state = State.BEGIN_HEADER_NAME;
                        this.notifyV8Consumer();
                        break;
                    }
                    if (this.readContent(input)) break;
                    return;
                }
            }
        }
    }

    private void notifyV8Consumer() {
        Consumer<V8MessageDecoder> consumer = this.v8VmVersionConsumer;
        if (consumer != null) {
            this.v8VmVersionConsumer = null;
            consumer.consume((Object)this);
        }
    }

    private boolean readContent(@NotNull ByteBuf buffer) throws IOException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/v8/V8MessageDecoder", "readContent"));
        }
        CharSequence result = this.readChars(buffer);
        if (result == null) {
            return false;
        }
        this.state = State.BEGIN_HEADER_NAME;
        if (this.v8Version == null && result.length() > 0 && result.charAt(0) == '{') {
            this.v8Version = "4.0.0";
            this.notifyV8Consumer();
        }
        this.messageConsumer.consume((Object)result);
        return true;
    }

    private boolean readName(@NotNull ByteBuf buffer, @NotNull StringBuilder builder) {
        int i;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/v8/V8MessageDecoder", "readName"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/v8/V8MessageDecoder", "readName"));
        }
        int n = buffer.writerIndex();
        for (i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == ':') {
                buffer.readerIndex(i + 1);
                return true;
            }
            if (c == '\r') continue;
            if (c == '\n') {
                buffer.readerIndex(i + 1);
                this.state = State.BEGIN_CONTENT;
                return true;
            }
            builder.append(c);
        }
        buffer.readerIndex(i);
        return false;
    }

    private static boolean readValue(@NotNull ByteBuf buffer, @Nullable StringBuilder builder) {
        int i;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/v8/V8MessageDecoder", "readValue"));
        }
        int n = buffer.writerIndex();
        boolean skipSpace = true;
        for (i = buffer.readerIndex(); i < n; ++i) {
            char c = (char)buffer.getByte(i);
            if (c == '\n') {
                buffer.readerIndex(i + 1);
                return true;
            }
            if (c == '\r' && i < n - 1 && buffer.getByte(i + 1) == 10) {
                buffer.readerIndex(i + 2);
                return true;
            }
            if (skipSpace && c == ' ') {
                skipSpace = false;
                continue;
            }
            if (builder == null || c == '\r') continue;
            builder.append(c);
        }
        buffer.readerIndex(i);
        return false;
    }

    private static enum State {
        BEGIN_HEADER_NAME,
        BEGIN_HEADER_VALUE,
        BEGIN_CONTENT;

    }
}

