/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.HashMap;
import com.intellij.util.descriptors.ConfigFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaeeCachesUtil {
    private static final Key<Map<CachedValueProviderProvider<?, ?>, CachedValue<?>>> JAVAEE_CACHED_VALUES_REGISTRY = Key.create((String)"JAVAEE_CACHED_VALUES_REGISTRY");

    private JavaeeCachesUtil() {
    }

    @Nullable
    public static <T> T getJavaeeValue(PsiElement element, CachedValueProviderProvider<T, PsiElement> providerProvider, FacetTypeId<? extends JavaeeFacet> expectedFacetType) {
        if (element == null || !JavaeeCachesUtil.isEnabled(element, expectedFacetType)) {
            return null;
        }
        return JavaeeCachesUtil.getJavaeeValue(element, element.getManager(), providerProvider);
    }

    @Nullable
    public static <T, V extends UserDataHolder> T getJavaeeValue(V element, PsiManager psiManager, CachedValueProviderProvider<T, V> providerProvider) {
        if (element == null) {
            return null;
        }
        Map registry = (Map)element.getUserData(JAVAEE_CACHED_VALUES_REGISTRY);
        if (registry != null) {
            CachedValue value = (CachedValue)registry.get(providerProvider);
            if (value != null) {
                return (T)value.getValue();
            }
        } else {
            registry = new HashMap();
            element.putUserData(JAVAEE_CACHED_VALUES_REGISTRY, (Object)registry);
        }
        CachedValue role = CachedValuesManager.getManager((Project)psiManager.getProject()).createCachedValue(providerProvider.createProvider(element), false);
        registry.put(providerProvider, role);
        return (T)role.getValue();
    }

    private static boolean isEnabled(@NotNull PsiElement element, FacetTypeId<? extends JavaeeFacet> expectedFacetType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/j2ee/JavaeeCachesUtil", "isEnabled"));
        }
        JavaeeFacetUtil instance = JavaeeFacetUtil.getInstance();
        if (instance == null) {
            return false;
        }
        for (FacetTypeId typeId : instance.getAllJavaeeFacetTypes()) {
            JavaeeFacet facet = instance.getJavaeeFacet(element, typeId);
            if (facet == null || !facet.getTypeId().equals(expectedFacetType)) continue;
            return true;
        }
        return false;
    }

    public static Object[] getDependencyItems(ConfigFile deploymentDescriptor) {
        return new Object[]{deploymentDescriptor, deploymentDescriptor.getXmlFile(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};
    }

    public static interface CachedValueProviderProvider<T, V extends UserDataHolder> {
        public CachedValueProvider<T> createProvider(V var1);
    }
}

