/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.actions;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.CommonModelManager;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.EjbDataHolder;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.EjbView;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.ejb.EjbRootElement;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EnterpriseBeanSet;
import com.intellij.javaee.model.xml.ejb.EnterpriseBeans;
import com.intellij.javaee.module.view.JavaeeAbstractCreateAction;
import com.intellij.javaee.module.view.ejb.CreateNewEjbDialog;
import com.intellij.javaee.module.view.ejb.EjbUrl;
import com.intellij.javaee.module.view.ejb.editor.EjbAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCreateEjbAction<T extends EnterpriseBean>
extends JavaeeAbstractCreateAction<T, EjbFacet> {
    @Nullable
    private final EjbFacet myEjbFacet;

    protected AbstractCreateEjbAction(String text, @Nullable EjbFacet ejbFacet, Icon icon) {
        super(text, "", icon, EjbFacet.ID);
        this.myEjbFacet = ejbFacet;
    }

    @Override
    protected EjbFacet getFacet(AnActionEvent e) {
        return this.myEjbFacet == null ? (EjbFacet)super.getFacet(e) : this.myEjbFacet;
    }

    protected AbstractCreateEjbAction(String text, Icon icon) {
        this(text, null, icon);
    }

    @Override
    protected void showAndSelect(@NotNull EjbFacet facet, @NotNull T ejb) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/module/view/ejb/actions/AbstractCreateEjbAction", "showAndSelect"));
        }
        if (ejb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ejb", "com/intellij/javaee/module/view/ejb/actions/AbstractCreateEjbAction", "showAndSelect"));
        }
        EjbView.select(facet.getModule().getProject(), EjbUrl.getPath(ejb), true);
    }

    @Override
    protected T createElement(@NotNull EjbFacet facet, @NotNull String packageName, @Nullable PsiDirectory firstDirectory) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/javaee/module/view/ejb/actions/AbstractCreateEjbAction", "createElement"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javaee/module/view/ejb/actions/AbstractCreateEjbAction", "createElement"));
        }
        Project project = facet.getModule().getProject();
        EjbDataHolder ejbInfo = this.createEjbInfo(facet.getMergedRoot());
        ejbInfo.setClassDirectory(firstDirectory);
        ejbInfo.setPackage(packageName);
        CreateNewEjbDialog createNewEjbDialog = new CreateNewEjbDialog(project, ejbInfo, facet);
        if (createNewEjbDialog.showAndGet()) {
            EjbAsVirtualFileImpl file;
            T ejb = this.createEjb(facet, facet.getMergedRoot().getEnterpriseBeans(), createNewEjbDialog.getEjbInfo());
            if (ejb == null) {
                return null;
            }
            EjbAsVirtualFileImpl ejbAsVirtualFileImpl = file = JamCommonUtil.getXmlTag(ejb) == null ? ((PsiClass)ejb.getEjbClass().getValue()).getContainingFile().getVirtualFile() : EjbAsVirtualFileImpl.findFile(ejb);
            if (file != null) {
                FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, true);
            }
            return ejb;
        }
        return null;
    }

    protected abstract EjbDataHolder createEjbInfo(EjbRootElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T createEjb(EjbFacet facet, EnterpriseBeanSet beanSet, final EjbDataHolder ejbInfo) {
        PsiFile[] psiFileArray;
        final Module module = facet.getModule();
        Project project = module.getProject();
        final EnterpriseBeans domBeanSet = (EnterpriseBeans)CommonModelManager.getInstance().getDomElement((CommonModelElement)beanSet);
        if (domBeanSet != null) {
            PsiFile[] psiFileArray2 = new PsiFile[1];
            psiFileArray = psiFileArray2;
            psiFileArray2[0] = DomUtil.getFile((DomElement)domBeanSet);
        } else {
            psiFileArray = PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFiles = psiFileArray;
        LocalHistoryAction a = LocalHistory.getInstance().startAction(J2EEBundle.message((String)"label.text.creating.ejb", (Object[])new Object[]{ejbInfo.getName()}));
        try {
            new WriteCommandAction<EnterpriseBean>(project, J2EEBundle.message((String)"dialog.title.create.new.ejb.0", (Object[])new Object[]{ejbInfo.getName()}), psiFiles){

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                protected void run(@NotNull Result<EnterpriseBean> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/module/view/ejb/actions/AbstractCreateEjbAction$1", "run"));
                    }
                    if (domBeanSet != null) {
                        ejbInfo.createEjb(domBeanSet);
                    } else {
                        ejbInfo.createEjbClasses(module);
                    }
                }
            }.execute().getResultObject();
        }
        finally {
            a.finish();
        }
        return EjbUtil.findEjbByName(beanSet.getModule(), ejbInfo.getName());
    }
}

