/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel;

import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.ejb.EjbUtil;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.JavaeeModelElement;
import com.intellij.javaee.model.common.ejb.CmpField;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.enums.Multiplicity;
import com.intellij.javaee.model.xml.ejb.CmrField;
import com.intellij.javaee.model.xml.ejb.EjbJar;
import com.intellij.javaee.model.xml.ejb.EjbRelation;
import com.intellij.javaee.module.view.ejb.moduleLevel.EditEjbRelationshipDialog;
import com.intellij.javaee.module.view.nodes.JavaeeDeleteProvider;
import com.intellij.javaee.ui.DefaultUserResponse;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.diagram.PersistenceDiagramSupport;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EjbPersistenceDiagramSupport
implements PersistenceDiagramSupport<EjbJar, EntityBean, JavaeeModelElement> {
    private Map<PsiClass, EntityBean> myClassMap;
    private List<EntityBean> myPersistentObjects;
    private final EjbFacet myFacet;

    public EjbPersistenceDiagramSupport(EjbFacet facet) {
        this.myFacet = facet;
    }

    public EjbFacet getFacet() {
        return this.myFacet;
    }

    public ModificationTracker getModificationTracker(EjbJar ejbJar) {
        return this.myFacet.getModificationTracker();
    }

    public void startDataModelUpdate(EjbJar ejbJar) {
        this.myPersistentObjects = new ArrayList<EntityBean>();
        for (com.intellij.javaee.model.xml.ejb.EntityBean entityBean : ejbJar.getEnterpriseBeans().getEntities()) {
            if (!EjbUtil.isCMP((EnterpriseBean)entityBean, null)) continue;
            this.myPersistentObjects.add((EntityBean)entityBean);
        }
        this.myClassMap = ContainerUtil.newMapFromValues(this.myPersistentObjects.iterator(), (Convertor)new Convertor<EntityBean, PsiClass>(){

            public PsiClass convert(EntityBean o) {
                return (PsiClass)o.getEjbClass().getValue();
            }
        });
    }

    public void finishDataModelUpdate() {
        this.myPersistentObjects = null;
        this.myClassMap = null;
    }

    public String getUniqueId(EntityBean entityBean) {
        return PersistenceCommonUtil.getUniqueId((PsiElement)(entityBean == null ? null : entityBean.getIdentifyingPsiElement()));
    }

    public void processEntities(PairProcessor<? super EntityBean, String> pairProcessor, boolean superclasses, boolean embeddables) {
        for (EntityBean entityBean : this.myPersistentObjects) {
            if (pairProcessor.process((Object)entityBean, entityBean.getEjbName().getValue())) continue;
            return;
        }
    }

    public void processSuper(EntityBean sourceEntity, PairProcessor<? super EntityBean, String> pairProcessor) {
        PsiClass psiClass = (PsiClass)sourceEntity.getEjbClass().getValue();
        if (psiClass == null) {
            return;
        }
        for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass.getSuperClass())) {
            EntityBean superObject = this.myClassMap.get(curClass);
            if (superObject == null || pairProcessor.process((Object)superObject, (Object)superObject.getEjbClass().getStringValue())) continue;
            return;
        }
    }

    public void processRelated(EntityBean sourceEntity, PairProcessor<? super JavaeeModelElement, String> pairProcessor) {
        Iterator iterator = sourceEntity.getCmrFields().iterator();
        while (iterator.hasNext()) {
            com.intellij.javaee.model.common.ejb.CmrField cmrField;
            com.intellij.javaee.model.common.ejb.CmrField field = (cmrField = (com.intellij.javaee.model.common.ejb.CmrField)iterator.next()).getOppositeField();
            if (pairProcessor.process((Object)cmrField, (Object)(field == null ? null : field.getEntityBeanName()))) continue;
            return;
        }
    }

    public void processEmbedded(EntityBean sourceEntity, PairProcessor<? super JavaeeModelElement, String> pairProcessor) {
    }

    public void processAttributes(EntityBean entityBean, PairProcessor<? super JavaeeModelElement, String> pairProcessor) {
        for (CmpField cmpField : entityBean.getCmpFields()) {
            if (pairProcessor.process((Object)cmpField, cmpField.getFieldName().getValue())) continue;
            return;
        }
    }

    public EntityBean getAttributeTarget(JavaeeModelElement attribute) {
        assert (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField);
        return ((com.intellij.javaee.model.common.ejb.CmrField)attribute).getOppositeEntity();
    }

    public JavaeeModelElement getInverseSideAttribute(JavaeeModelElement attribute) {
        assert (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField);
        return ((com.intellij.javaee.model.common.ejb.CmrField)attribute).getOppositeField();
    }

    public String getAttributeName(JavaeeModelElement attribute) {
        if (attribute instanceof CmpField) {
            return (String)((CmpField)attribute).getFieldName().getValue();
        }
        if (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField) {
            return (String)((com.intellij.javaee.model.common.ejb.CmrField)attribute).getCmrFieldName().getValue();
        }
        return null;
    }

    public PsiType getAttributePsiType(JavaeeModelElement attribute) {
        if (attribute instanceof CmpField) {
            return EjbUtil.findType((CmpField)attribute);
        }
        if (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField) {
            return EjbUtil.findType((com.intellij.javaee.model.common.ejb.CmrField)attribute);
        }
        return null;
    }

    @NotNull
    public String getEntityTypeName(EntityBean entityBean) {
        String string = ElementPresentationManager.getTypeNameForObject((Object)entityBean);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/EjbPersistenceDiagramSupport", "getEntityTypeName"));
        }
        return string;
    }

    @NotNull
    public String getAttributeTypeName(JavaeeModelElement attribute) {
        if (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField) {
            EjbRelation relation = EjbPersistenceDiagramSupport.getEjbRelation(attribute);
            String relationName = (String)relation.getEjbRelationName().getValue();
            String typeName = ElementPresentationManager.getTypeNameForObject((Object)relation);
            String string = StringUtil.isEmpty((String)relationName) ? typeName : typeName + ": " + relationName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/EjbPersistenceDiagramSupport", "getAttributeTypeName"));
            }
            return string;
        }
        String string = ElementPresentationManager.getTypeNameForObject((Object)attribute);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/EjbPersistenceDiagramSupport", "getAttributeTypeName"));
        }
        return string;
    }

    public boolean isIdAttribute(JavaeeModelElement attribute) {
        if (attribute instanceof CmpField) {
            CmpField field = (CmpField)attribute;
            EntityBean ejb = field.getEntityBean();
            assert (ejb != null);
            if (ejb.getPrimkeyField().getValue() == attribute) {
                return true;
            }
            PsiClass pkClass = (PsiClass)ejb.getPrimKeyClass().getValue();
            String fieldName = (String)field.getFieldName().getValue();
            if (pkClass != null && StringUtil.isNotEmpty((String)fieldName) && pkClass.findFieldByName(fieldName, true) != null) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getAttributeMultiplicityLabel(JavaeeModelElement first, JavaeeModelElement second, boolean isSource) {
        com.intellij.javaee.model.common.ejb.CmrField oppositeField;
        assert (first instanceof com.intellij.javaee.model.common.ejb.CmrField);
        com.intellij.javaee.model.common.ejb.CmrField field = (com.intellij.javaee.model.common.ejb.CmrField)first;
        Object multiplicity = isSource ? (Multiplicity)field.getMultiplicity().getValue() : ((oppositeField = field.getOppositeField()) != null ? (Multiplicity)oppositeField.getMultiplicity().getValue() : null);
        String string = multiplicity == Multiplicity.MANY ? "*" : (multiplicity == Multiplicity.ONE ? "1" : "?");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/EjbPersistenceDiagramSupport", "getAttributeMultiplicityLabel"));
        }
        return string;
    }

    public Icon getEntityIcon(EntityBean entityBean) {
        return ElementPresentationManager.getIcon((Object)entityBean);
    }

    public Icon getAttributeIcon(JavaeeModelElement attribute, boolean forceId) {
        return ElementPresentationManager.getIcon((Object)attribute);
    }

    @NotNull
    public TypeSafeDataProvider createDataProvider(final PersistenceDiagram<EjbJar, EntityBean, JavaeeModelElement> diagram) {
        TypeSafeDataProvider typeSafeDataProvider = new TypeSafeDataProvider(){

            public void calcData(DataKey key, DataSink sink) {
                if (PlatformDataKeys.HELP_ID.equals(key)) {
                    sink.put(PlatformDataKeys.HELP_ID, (Object)"newEJBedit_module_rel");
                } else if (LangDataKeys.MODULE.equals(key)) {
                    sink.put(LangDataKeys.MODULE, (Object)((EjbJar)diagram.getUnit()).getModule());
                } else if (LangDataKeys.MODULE_CONTEXT.equals(key)) {
                    sink.put(LangDataKeys.MODULE_CONTEXT, (Object)((EjbJar)diagram.getUnit()).getModule());
                } else if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.equals(key)) {
                    EntityBean element;
                    EntityBean entityBean = (EntityBean)diagram.getSelectedEntity();
                    Object object = element = entityBean != null ? entityBean : (JavaeeModelElement)diagram.getSelectedAttribute();
                    if (element != null) {
                        sink.put(PlatformDataKeys.DELETE_ELEMENT_PROVIDER, (Object)new JavaeeDeleteProvider((CommonModelElement)element, new DefaultUserResponse((CommonModelElement)element)));
                    }
                } else if (CommonDataKeys.NAVIGATABLE.equals(key)) {
                    PsiElement psiElement = null;
                    EnterpriseBean ejb = (EnterpriseBean)diagram.getSelectedEntity();
                    if (ejb != null) {
                        psiElement = (PsiElement)ejb.getEjbClass().getValue();
                    } else {
                        JavaeeModelElement attribute = (JavaeeModelElement)diagram.getSelectedAttribute();
                        if (attribute != null) {
                            psiElement = attribute.getIdentifyingPsiElement();
                        }
                    }
                    if (psiElement instanceof Navigatable) {
                        sink.put(CommonDataKeys.NAVIGATABLE, (Object)((Navigatable)psiElement));
                    } else if (psiElement != null) {
                        VirtualFile virtualFile = psiElement.getContainingFile().getVirtualFile();
                        assert (virtualFile != null);
                        sink.put(CommonDataKeys.NAVIGATABLE, (Object)new OpenFileDescriptor(psiElement.getProject(), virtualFile, psiElement.getTextOffset()));
                    }
                }
            }
        };
        if (typeSafeDataProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/module/view/ejb/moduleLevel/EjbPersistenceDiagramSupport", "createDataProvider"));
        }
        return typeSafeDataProvider;
    }

    public boolean processEditNode(PersistenceDiagram<EjbJar, EntityBean, JavaeeModelElement> persistenceDiagram, EntityBean entityBean) {
        return false;
    }

    public boolean processEditEdge(PersistenceDiagram<EjbJar, EntityBean, JavaeeModelElement> persistenceDiagram) {
        JavaeeModelElement attribute = (JavaeeModelElement)persistenceDiagram.getSelectedAttribute();
        if (attribute instanceof com.intellij.javaee.model.common.ejb.CmrField) {
            EditEjbRelationshipDialog dialog = new EditEjbRelationshipDialog(EjbPersistenceDiagramSupport.getEjbRelation(attribute));
            dialog.show();
        }
        return true;
    }

    public void processCreateEdge(PersistenceDiagram<EjbJar, EntityBean, JavaeeModelElement> persistenceDiagram, EntityBean sourceEntity, EntityBean targetEntity) {
        EditEjbRelationshipDialog dialog = new EditEjbRelationshipDialog((EjbJar)persistenceDiagram.getUnit(), (String)sourceEntity.getEjbName().getValue(), (String)targetEntity.getEjbName().getValue());
        dialog.show();
    }

    public void customizeGraphView(Graph2DView view, EditMode editMode) {
    }

    static EjbRelation getEjbRelation(JavaeeModelElement attribute) {
        assert (attribute != null);
        EjbRelation relation = (EjbRelation)((CmrField)attribute).getParentOfType(EjbRelation.class, true);
        assert (relation != null);
        return relation;
    }
}

