/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.web.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.managedbean.ManagedBeanService;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.model.common.managedbean.ManagedBean;
import com.intellij.javaee.module.view.common.editor.FacetAsVirtualFileImpl;
import com.intellij.javaee.module.view.ejb.nodes.ManagedBeanNodeDescriptor;
import com.intellij.javaee.module.view.nodes.J2EEModuleParameters;
import com.intellij.javaee.module.view.nodes.JavaeeDeploymentDescriptorNodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeFacetNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.FilterNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.ListenerNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.ServletNodeDescriptor;
import com.intellij.javaee.module.view.web.nodes.WebFragmentDescriptor;
import com.intellij.javaee.module.view.web.nodes.WebRootNodeDescriptor;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.descriptors.ConfigFile;
import java.util.ArrayList;
import java.util.List;

public class WebFacetNodeDescriptor
extends JavaeeFacetNodeDescriptor<WebFacet> {
    public WebFacetNodeDescriptor(WebFacet facet, NodeDescriptor parentDescriptor, Object parameters) {
        super(facet, parentDescriptor, parameters);
    }

    @Override
    public Object getData(String dataId) {
        if (DataConstants.NAVIGATABLE.equals(dataId)) {
            if (((WebFacet)this.getFacet()).getRoot() == null) {
                return null;
            }
            FacetAsVirtualFileImpl file = this.getVirtualFile();
            if (file == null || !file.isValid()) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, (VirtualFile)file);
        }
        return super.getData(dataId);
    }

    public SimpleNode[] getChildren() {
        WebFacet webFacet = (WebFacet)this.getFacet();
        if (webFacet.isDisposed()) {
            return EMPTY_ARRAY;
        }
        ArrayList<SimpleNode> result = new ArrayList<SimpleNode>();
        this.addWebModuleStructureNodes(result);
        List directories = webFacet.getResources();
        for (PsiDirectory directory : directories) {
            Module module;
            try {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(directory.getVirtualFile());
                if (jarFile != null) {
                    result.add(new WebFragmentDescriptor(directory.getParent(), jarFile, (NodeDescriptor)this, this.getParameters()));
                    continue;
                }
            }
            catch (Throwable jarFile) {
                // empty catch block
            }
            if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)directory)) == null) continue;
            result.add(new WebFragmentDescriptor(directory.getParent(), module, (NodeDescriptor)this, this.getParameters()));
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    private void addWebModuleStructureNodes(List<SimpleNode> result) {
        ConfigFile[] deploymentDescriptors;
        J2EEModuleParameters parameters = (J2EEModuleParameters)((Object)this.getParameters());
        if (!parameters.showMembers()) {
            return;
        }
        WebFacet webFacet = (WebFacet)this.getFacet();
        List webRoots = webFacet.getWebRoots();
        for (ConfigFile[] webRoot : webRoots) {
            VirtualFile webRootDir = webRoot.getFile();
            PsiDirectory directory = webRootDir != null && webRootDir.isValid() ? PsiManager.getInstance((Project)this.myProject).findDirectory(webRootDir) : null;
            if (directory == null) continue;
            result.add((SimpleNode)new WebRootNodeDescriptor((WebRoot)webRoot, directory, this, (Object)parameters));
        }
        for (ConfigFile descriptor : deploymentDescriptors = webFacet.getDescriptorsContainer().getConfigFiles()) {
            if (!descriptor.isValid()) continue;
            result.add((SimpleNode)new JavaeeDeploymentDescriptorNodeDescriptor(descriptor, (NodeDescriptor)this, (Object)parameters));
        }
        WebModel webModel = webFacet.getWebModel();
        for (CommonServlet servlet : webModel.getServlets()) {
            result.add((SimpleNode)new ServletNodeDescriptor(servlet, (NodeDescriptor)this, (Object)parameters));
        }
        for (CommonFilter filter : webModel.getFilters()) {
            result.add((SimpleNode)new FilterNodeDescriptor(filter, (NodeDescriptor)this, (Object)parameters));
        }
        for (CommonListener listener : webModel.getListeners()) {
            result.add((SimpleNode)new ListenerNodeDescriptor(listener, (NodeDescriptor)this, (Object)parameters));
        }
        for (ManagedBean managedBean : ManagedBeanService.getInstance((Project)this.myProject).getManagedBeans(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)((WebFacet)this.getFacet()).getModule()))) {
            result.add((SimpleNode)new ManagedBeanNodeDescriptor(managedBean, (NodeDescriptor)this, (Object)parameters));
        }
    }
}

