/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.framework.FrameworkType;
import com.intellij.javaee.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.oss.server.AppServerFrameworkLibrariesDescriptionLoader;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class AppServerLibrariesProviderImpl
extends AppServerLibrariesProvider {
    private final JavaeeIntegration myIntegration;
    private String myVersion;
    private String myServerHome;

    public AppServerLibrariesProviderImpl(@NotNull JavaeeIntegration integration, @NotNull JavaeePersistentData persistentData) {
        if (integration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "integration", "com/intellij/javaee/oss/server/AppServerLibrariesProviderImpl", "<init>"));
        }
        if (persistentData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentData", "com/intellij/javaee/oss/server/AppServerLibrariesProviderImpl", "<init>"));
        }
        this.myIntegration = integration;
        this.myVersion = this.myIntegration.getServerVersionSilently(persistentData);
        this.myServerHome = persistentData.HOME;
    }

    @NotNull
    public Map<FrameworkType, List<File>> getFrameworkLibraries() {
        Map<FrameworkType, List<File>> map = AppServerFrameworkLibrariesDescriptionLoader.loadFrameworkLibraries(this.myIntegration, this.myServerHome, this.myVersion);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/server/AppServerLibrariesProviderImpl", "getFrameworkLibraries"));
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppServerLibrariesProviderImpl provider = (AppServerLibrariesProviderImpl)((Object)o);
        return ((Object)((Object)this.myIntegration)).equals((Object)provider.myIntegration) && this.myServerHome.equals(provider.myServerHome) && this.myVersion.equals(provider.myVersion);
    }

    public int hashCode() {
        return 31 * (31 * ((Object)((Object)this.myIntegration)).hashCode() + this.myVersion.hashCode()) + this.myServerHome.hashCode();
    }
}

