/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.javaee.run.execution.ExecutionHelper;
import com.intellij.javaee.run.execution.J2EELocalProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EEProcess;
import com.intellij.javaee.run.execution.J2EEProcessHandlerHelper;
import com.intellij.javaee.run.execution.J2EEProcessHandlerWrapper;
import com.intellij.javaee.run.execution.J2EERunnableState;
import com.intellij.javaee.run.execution.LocalJavaeeServerProcessHandler;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JavaCommandLineLocalState
extends CommandLineState
implements JavaCommandLine,
J2EERunnableState {
    private final JavaCommandLineStartupPolicy myCommandLineProvider;
    private final CommonStrategy myConfiguration;
    private final ExecutionHelper myExecutionHelper;
    private JavaParameters myJavaParameters;
    private J2EEProcessHandlerWrapper myProcessHandler;

    public JavaCommandLineLocalState(JavaCommandLineStartupPolicy commandLineProvider, CommonStrategy configuration, final Executor executor, ExecutionEnvironment environment, ExecutionHelper executionHelper) {
        super(environment);
        this.myCommandLineProvider = commandLineProvider;
        this.myConfiguration = configuration;
        this.myExecutionHelper = executionHelper;
        this.setConsoleBuilder(new TextConsoleBuilder(){
            private final ArrayList<Filter> myFilters = new ArrayList();

            public void setViewer(boolean isViewer) {
            }

            public ConsoleView getConsole() {
                ConsoleView result = JavaCommandLineLocalState.this.myExecutionHelper.createConsole(JavaCommandLineLocalState.this.myProcessHandler, executor);
                for (Filter filter : this.myFilters) {
                    result.addMessageFilter(filter);
                }
                return result;
            }

            public void addFilter(@NotNull Filter filter) {
                if (filter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/javaee/run/execution/JavaCommandLineLocalState$1", "addFilter"));
                }
                this.myFilters.add(filter);
            }
        });
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javaee/run/execution/JavaCommandLineLocalState", "execute"));
        }
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/javaee/run/execution/JavaCommandLineLocalState", "execute"));
        }
        J2EEServerInstance serverInstance = this.myExecutionHelper.createServerInstance();
        this.myProcessHandler = new J2EELocalProcessHandlerWrapper(serverInstance, executor, this.myConfiguration, this);
        ConsoleView console = this.createConsole(executor);
        if (console != null) {
            console.attachToProcess((ProcessHandler)this.myProcessHandler);
        }
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)this.myProcessHandler, this.createActions(console, this.myProcessHandler, executor));
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/JavaCommandLineLocalState", "execute"));
        }
        return defaultExecutionResult;
    }

    @Override
    public J2EEProcess startJ2EEProcess(J2EEProcessHandlerWrapper processHandlerWrapper) throws ExecutionException {
        try {
            this.myExecutionHelper.checkAddressesAlreadyInUse(processHandlerWrapper);
            OSProcessHandler startupHandler = JavaCommandLineStateUtil.startProcess((GeneralCommandLine)this.createCommandLine());
            JavaCommandLineServerProcessHandler result = new JavaCommandLineServerProcessHandler(processHandlerWrapper.createHelper(), startupHandler);
            processHandlerWrapper.connectToProcess();
            RunnerSettings runnerSettings = this.getRunnerSettings();
            JavaRunConfigurationExtensionManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)this.myConfiguration, (ProcessHandler)processHandlerWrapper, runnerSettings);
            return result;
        }
        catch (Exception e) {
            throw new ExecutionException(e.getLocalizedMessage());
        }
    }

    @NotNull
    protected AnAction[] createActions(ConsoleView console, ProcessHandler processHandler, Executor executor) {
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("JavaeeRunToolWindowToolbar")};
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/execution/JavaCommandLineLocalState", "createActions"));
        }
        return anActionArray;
    }

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        this.getJavaParameters().getVMParametersList().addParametersString(this.myConfiguration.getSettingsBean().COMMON_VM_ARGUMENTS);
        return this.getJavaParameters().toCommandLine();
    }

    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myJavaParameters == null) {
            this.myJavaParameters = this.myCommandLineProvider.createCommandLine((CommonModel)this.myConfiguration);
            Sdk jre = this.myConfiguration.getJre();
            if (jre == null) {
                throw new CantRunException(ExecutionBundle.message((String)"project.has.no.jdk.configured.error.message", (Object[])new Object[0]));
            }
            this.myJavaParameters.setJdk(jre);
            this.myJavaParameters.getClassPath().add(((JavaSdkType)jre.getSdkType()).getToolsPath(jre));
            for (RunConfigurationExtension ext : (RunConfigurationExtension[])Extensions.getExtensions((ExtensionPointName)RunConfigurationExtension.EP_NAME)) {
                ext.updateJavaParameters((RunConfigurationBase)this.myConfiguration, this.myJavaParameters, this.getRunnerSettings());
            }
        }
        return this.myJavaParameters;
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        throw new UnsupportedOperationException();
    }

    private static class JavaCommandLineServerProcessHandler
    extends LocalJavaeeServerProcessHandler {
        public JavaCommandLineServerProcessHandler(J2EEProcessHandlerHelper helper, OSProcessHandler startupHandler) {
            super(helper, startupHandler, false);
        }

        @Override
        protected void onBaseProcessTerminated() {
            this.terminateAndNotify();
        }

        @Override
        public void shutdown() {
            this.myStartupHandler.destroyProcess();
        }
    }
}

