/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.artifact;

import com.intellij.javaee.context.DefaultWebModuleContextProvider;
import com.intellij.javaee.context.WebModuleContextProvider;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesElementType;
import com.intellij.javaee.ui.packaging.JavaeeFacetResourcesPackagingElement;
import com.intellij.javaee.ui.packaging.WarArtifactType;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Ref;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebArtifactUtilImpl
extends WebArtifactUtil {
    public boolean isWebApplication(@NotNull ArtifactType artifactType) {
        if (artifactType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactType", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "isWebApplication"));
        }
        return artifactType.equals((Object)ExplodedWarArtifactType.getInstance()) || artifactType.equals((Object)WarArtifactType.getInstance());
    }

    public ArtifactType getExplodedWarArtifactType() {
        return ExplodedWarArtifactType.getInstance();
    }

    public ArtifactType getWarArtifactType() {
        return WarArtifactType.getInstance();
    }

    public Collection<? extends Artifact> getWebArtifacts(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "getWebArtifacts"));
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Artifact artifact : ArtifactManager.getInstance((Project)project).getArtifacts()) {
            if (!this.isWebApplication(artifact.getArtifactType())) continue;
            result.add(artifact);
        }
        return result;
    }

    public void addLibrary(@NotNull Library library, @NotNull Artifact artifact, @NotNull Project project) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "addLibrary"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "addLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "addLibrary"));
        }
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
        List elements = PackagingElementFactory.getInstance().createLibraryElements(library);
        for (PackagingElement element : elements) {
            String dir = element.getFilesKind(artifactManager.getResolvingContext()).containsDirectoriesWithClasses() ? "classes" : "lib";
            artifactManager.addElementsToDirectory(artifact, "WEB-INF/" + dir, element);
        }
    }

    public Collection<? extends ArtifactType> getWebArtifactTypes() {
        ArrayList<ArtifactType> list = new ArrayList<ArtifactType>();
        list.add(this.getExplodedWarArtifactType());
        list.add(this.getWarArtifactType());
        return list;
    }

    @Nullable
    public String getContextRoot(@NotNull Artifact earArtifact, @NotNull WebFacet webFacet) {
        if (earArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earArtifact", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "getContextRoot"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "getContextRoot"));
        }
        return WebFacetContextProvider.getModuleContext((WebModuleContextProvider)DefaultWebModuleContextProvider.INSTANCE, (Artifact)earArtifact, (WebFacet)webFacet);
    }

    public String getModuleWebUri(@NotNull Artifact earArtifact, final @NotNull WebFacet webFacet) {
        if (earArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "earArtifact", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "getModuleWebUri"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl", "getModuleWebUri"));
        }
        Project project = webFacet.getModule().getProject();
        final Ref parentElementNameRef = Ref.create(null);
        final PackagingElementResolvingContext context = ArtifactManager.getInstance((Project)project).getResolvingContext();
        PackagingElementProcessor<JavaeeFacetResourcesPackagingElement> processor = new PackagingElementProcessor<JavaeeFacetResourcesPackagingElement>(){

            public boolean process(@NotNull JavaeeFacetResourcesPackagingElement element, @NotNull PackagingElementPath path) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl$1", "process"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javaee/web/artifact/WebArtifactUtilImpl$1", "process"));
                }
                CompositePackagingElement parent = path.getLastParent();
                if (webFacet.equals((Object)element.findFacet(context)) && parent != null) {
                    parentElementNameRef.set((Object)parent.getName());
                }
                return true;
            }
        };
        ArtifactUtil.processPackagingElements((Artifact)earArtifact, (PackagingElementType)JavaeeFacetResourcesElementType.getInstance(), (PackagingElementProcessor)processor, (PackagingElementResolvingContext)context, (boolean)true);
        return (String)parentElementNameRef.get();
    }
}

