/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.JavaeeFieldRefactoringSupport;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AttributeRefactoringSupport
extends JavaeeFieldRefactoringSupport<PersistentAttribute> {
    public static final AttributeRefactoringSupport INSTANCE = new AttributeRefactoringSupport();

    public AttributeRefactoringSupport() {
        super(PersistentAttribute.class);
    }

    public Collection<PsiElement> getAccessors(PersistentAttribute attributeBase) {
        PsiMember member = attributeBase.getPsiMember();
        if (member == null) {
            return Collections.emptyList();
        }
        PsiClass psiClass = member.getContainingClass();
        SmartList list = new SmartList();
        String name = (String)attributeBase.getName().getValue();
        ContainerUtil.addIfNotNull((Collection)list, (Object)PropertyUtil.findPropertyField((PsiClass)psiClass, (String)name, (boolean)false));
        ContainerUtil.addIfNotNull((Collection)list, (Object)PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false));
        ContainerUtil.addIfNotNull((Collection)list, (Object)PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false));
        if (attributeBase.getAttributeModelHelper().isIdAttribute()) {
            PsiClass idClass;
            PersistentObject object = attributeBase.getPersistentObject();
            GenericValue idClassValue = object instanceof PersistentEntity ? ((PersistentEntity)object).getIdClassValue() : null;
            PsiClass psiClass2 = idClass = idClassValue != null ? (PsiClass)idClassValue.getValue() : null;
            if (idClass != null) {
                ContainerUtil.addIfNotNull((Collection)list, (Object)PropertyUtil.findPropertyGetter((PsiClass)idClass, (String)name, (boolean)false, (boolean)false));
                ContainerUtil.addIfNotNull((Collection)list, (Object)PropertyUtil.findPropertySetter((PsiClass)idClass, (String)name, (boolean)false, (boolean)false));
            }
        }
        return list;
    }

    public PersistentAttribute getModelElementFromPsi(PsiMember member) {
        if (!this.acceptPsiMember(member)) {
            return null;
        }
        if (member instanceof PsiMethod && PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)member))) {
            String propertyName = PropertyUtil.getPropertyName((PsiMethod)((PsiMethod)member));
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)member.getContainingClass(), (String)propertyName, (boolean)false, (boolean)false);
            return getter != null ? this.getModelElementFromPsi((PsiMember)getter) : null;
        }
        List attributes = PersistenceHelper.getHelper().getSharedModelBrowser().getPersistenceAttributes(member);
        if (attributes.isEmpty() && member instanceof PsiField) {
            String propertyName = PropertyUtil.getPropertyName((PsiMember)member);
            PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)member.getContainingClass(), (String)propertyName, (boolean)false, (boolean)false);
            return getter != null ? this.getModelElementFromPsi((PsiMember)getter) : null;
        }
        return (PersistentAttribute)ContainerUtil.getFirstItem((List)attributes);
    }

    @Override
    protected boolean acceptPsiMember(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/AttributeRefactoringSupport", "acceptPsiMember"));
        }
        return member.isValid() && member.isPhysical() && !member.hasModifierProperty("static") && !member.hasModifierProperty("final") && (AttributeRefactoringSupport.hasAccessors(member) || AttributeRefactoringSupport.isIdAttribute(member));
    }

    private static boolean hasAccessors(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/AttributeRefactoringSupport", "hasAccessors"));
        }
        String name = PropertyUtil.getPropertyName((PsiMember)member);
        if (name == null) {
            return false;
        }
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtil.findPropertyField((PsiClass)psiClass, (String)name, (boolean)false) != null;
        }
        if (PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false) != null) {
            return true;
        }
        return PropertyUtil.findPropertySetter((PsiClass)psiClass, (String)name, (boolean)false, (boolean)false) != null;
    }

    private static boolean isIdAttribute(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/AttributeRefactoringSupport", "isIdAttribute"));
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Collections.singleton("javax.persistence.IdClass"));
    }
}

