/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DasUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.TimeoutUtil;
import gnu.trove.THashMap;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class DataSourceObjectUsageCache
implements Disposable {
    private static final Comparator<Object> MY_COMPARATOR = (o1, o2) -> Comparing.compare((Comparable)((Object)DataSourceObjectUsageCache.getObjectName(o2, true)), (Comparable)((Object)DataSourceObjectUsageCache.getObjectName(o1, true)));
    private final Project myProject;
    private final GlobalSearchScope myLocalScope;
    private final GlobalSearchScope myGlobalScope;
    private final Object myLock = new Object();
    private final TreeMap<Object, UsageFlag> myPendingQueue = new TreeMap(MY_COMPARATOR);
    private final Map<Object, UsageFlag> myUsagesCache = new THashMap();
    private ProgressIndicator myProgress;
    private Runnable myTask;

    public DataSourceObjectUsageCache(Project project, final GlobalSearchScope localScope) {
        this.myProject = project;
        this.myLocalScope = localScope;
        final GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        this.myGlobalScope = localScope == null ? projectScope : new GlobalSearchScope(project){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jpa/generation/ui/DataSourceObjectUsageCache$1", "contains"));
                }
                return projectScope.contains(file) && !localScope.contains(file);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/jpa/generation/ui/DataSourceObjectUsageCache$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/jpa/generation/ui/DataSourceObjectUsageCache$1", "compare"));
                }
                return projectScope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/jpa/generation/ui/DataSourceObjectUsageCache$1", "isSearchInModuleContent"));
                }
                return projectScope.isSearchInModuleContent(aModule);
            }

            public boolean isSearchInLibraries() {
                return projectScope.isSearchInLibraries();
            }
        };
    }

    protected void cacheUpdated() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetchUsages(DbDataSource datasource) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProgress != null && this.myProgress.isCanceled()) {
                this.myTask = null;
                this.myProgress = null;
            }
            this.myPendingQueue.clear();
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                for (DasTable table : DasUtil.getTables((DbDataSource)datasource)) {
                    UsageFlag flag = this.myUsagesCache.get(table);
                    if (flag == null) {
                        this.myPendingQueue.put(table, UsageFlag.GLOBAL);
                        continue;
                    }
                    this.addFieldsToPendingQueue(table, flag);
                }
            }
            finally {
                accessToken.finish();
            }
        }
        this.startTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsageFlag getUsageFlag(Object object, boolean cachedOnly) {
        if (!(object instanceof DasTable) && !(object instanceof DasColumn)) {
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            UsageFlag cachedFlag = this.myUsagesCache.get(object);
            if (cachedFlag != null) {
                return cachedFlag;
            }
            if (cachedOnly) {
                return UsageFlag.PENDING;
            }
            if (object instanceof DasColumn) {
                UsageFlag tableFlag = this.getUsageFlag(((DasColumn)object).getTable(), false);
                if (tableFlag == UsageFlag.NONE) {
                    return UsageFlag.NONE;
                }
            } else if (!this.myPendingQueue.containsKey(object)) {
                this.myPendingQueue.put(object, UsageFlag.PENDING);
            }
        }
        this.startTask();
        return UsageFlag.PENDING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProgress != null) {
                this.myProgress.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTask() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTask != null || this.myPendingQueue.isEmpty()) {
                return;
            }
            this.myTask = () -> {
                Thread thread = Thread.currentThread();
                int oldPriority = thread.getPriority();
                ProgressIndicator progress = this.createProgressIndicator();
                Object object = this.myLock;
                synchronized (object) {
                    this.myProgress = progress;
                }
                try {
                    thread.setPriority(1);
                    progress.start();
                    this.processPendingObjects(progress);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    object = this.myLock;
                    synchronized (object) {
                        if (!this.myProgress.isCanceled()) {
                            this.myTask = null;
                            this.myProgress = null;
                        }
                    }
                    progress.stop();
                    thread.setPriority(oldPriority);
                }
            };
        }
        ApplicationManager.getApplication().executeOnPooledThread(this.myTask);
    }

    protected ProgressIndicator createProgressIndicator() {
        return new StatusBarProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingObjects(ProgressIndicator progress) {
        int totalDone = 0;
        while (true) {
            progress.checkCanceled();
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                int queueSize;
                UsageFlag searchScope;
                Object object;
                Object object2 = this.myLock;
                synchronized (object2) {
                    block13: {
                        if (!this.myPendingQueue.isEmpty()) break block13;
                        return;
                    }
                    object = this.myPendingQueue.keySet().iterator().next();
                    searchScope = this.myPendingQueue.get(object);
                }
                progress.setText(JpaMessages.message((String)"progress.database.usage.cache.text", (Object[])new Object[]{DataSourceObjectUsageCache.getObjectName(object, false)}));
                UsageFlag usageFlag = this.doCalculateUsageFlag(object, searchScope);
                Object object3 = this.myLock;
                synchronized (object3) {
                    UsageFlag prevFlag = this.myUsagesCache.put(object, usageFlag);
                    assert (prevFlag == null) : DataSourceObjectUsageCache.getObjectName(object, false) + ": " + (Object)((Object)usageFlag) + " was " + (Object)((Object)prevFlag);
                    this.addFieldsToPendingQueue(object, usageFlag);
                    this.myPendingQueue.remove(object);
                    queueSize = this.myPendingQueue.size();
                }
                progress.setFraction((double)(++totalDone) / (double)(queueSize + totalDone));
            }
            finally {
                accessToken.finish();
            }
            this.cacheUpdated();
            progress.checkCanceled();
            TimeoutUtil.sleep((long)10L);
        }
    }

    private void addFieldsToPendingQueue(Object object, UsageFlag usageFlag) {
        if (object instanceof DasTable) {
            for (DasColumn field : DasUtil.getColumns((DasObject)((DasTable)object))) {
                UsageFlag pendingFlag;
                if (usageFlag == UsageFlag.NONE) {
                    this.myUsagesCache.put(field, usageFlag);
                    this.myPendingQueue.remove(field);
                    continue;
                }
                if (this.myUsagesCache.containsKey(field) || (pendingFlag = this.myPendingQueue.get(field)) != null && pendingFlag != UsageFlag.PENDING) continue;
                this.myPendingQueue.put(field, usageFlag);
            }
        }
    }

    private UsageFlag doCalculateUsageFlag(Object object, UsageFlag searchScope) {
        assert (object instanceof PsiElement);
        PsiElement element = (PsiElement)object;
        if (searchScope == UsageFlag.LOCAL) {
            assert (this.myLocalScope != null);
            return ReferencesSearch.search((PsiElement)element, (SearchScope)this.myLocalScope).findFirst() != null ? UsageFlag.LOCAL : UsageFlag.NONE;
        }
        if (this.myLocalScope != null && ReferencesSearch.search((PsiElement)element, (SearchScope)this.myLocalScope).findFirst() != null) {
            return UsageFlag.LOCAL;
        }
        if (ReferencesSearch.search((PsiElement)element, (SearchScope)this.myGlobalScope).findFirst() != null) {
            return UsageFlag.GLOBAL;
        }
        return UsageFlag.NONE;
    }

    private static String getObjectName(Object object, boolean referenceName) {
        if (object instanceof DasTable) {
            return ((DasTable)object).getName();
        }
        DasColumn field = (DasColumn)object;
        return referenceName ? field.getName() : field.getTable().getName() + "@" + field.getName();
    }

    public static enum UsageFlag {
        PENDING,
        LOCAL,
        GLOBAL,
        NONE;

    }
}

