/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation.ui;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.generation.GenerationSettings;
import com.intellij.jpa.generation.ui.DatabaseSchemaImportDialog;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.ui.CaptionComponent;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportMappingsDialog
extends DialogWrapper
implements TypeSafeDataProvider {
    private JCheckBox myCbGenerateAnnotations;
    private JCheckBox myCbAddToUnit;
    private TextFieldWithBrowseButton myMappingName;
    private ComboboxWithBrowseButton myCbUnits;
    private JTextField myTfEntityNameSuffix;
    private JLabel myPackageLabel;
    private ReferenceEditorComboWithBrowseButton myPackageComponent;
    private JTextField myTfEntityNamePrefix;
    private CaptionComponent myCaptionComponent;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myTargetComponent;
    private JLabel myTargetLabel;
    private JPanel myPackagePanel;
    private JCheckBox myCbGenerateSeparateXML;
    private JCheckBox myCbGenerateSingleXml;
    private final PersistenceFacet myFacet;
    private final String myUnitName;
    private final Project myProject;
    private final PsiNameHelper myPsiNameHelper;
    private String myEntityNameSuffix = "Entity";
    private String myEntityNamePrefix = "";
    @NonNls
    static final String PACKAGE_RECENTS_KEY = "ImportMappingsDialog.RecentPackages";

    public ImportMappingsDialog(PersistenceFacet facet, String unitName) {
        super(facet.getModule().getProject(), false);
        this.myFacet = facet;
        this.myUnitName = unitName;
        this.$$$setupUI$$$();
        this.myProject = facet.getModule().getProject();
        this.myPsiNameHelper = PsiNameHelper.getInstance((Project)this.myProject);
        this.setupControls();
        this.init();
        this.restoreDialogValues();
    }

    public abstract void setupTargetControls(JLabel var1, TextFieldWithBrowseButton var2, CaptionComponent var3);

    protected String getDimensionServiceKey() {
        return "#com.intellij.jpa.generation.ui.ImportMappingsDialog";
    }

    protected void doOKAction() {
        this.storeDialogValues();
        if (this.askUserIfItsOkToCloseAndLoseEverything(true)) {
            super.doOKAction();
        }
    }

    private boolean askUserIfItsOkToCloseAndLoseEverything(boolean okAction) {
        return StringUtil.isEmpty((String)((JTextField)this.myTargetComponent.getChildComponent()).getText()) || Messages.showYesNoDialog((Component)this.getContentPane(), (String)(okAction ? JpaMessages.message((String)"message.text.confirm.generate.orm", (Object[])new Object[0]) : JpaMessages.message((String)"message.text.confirm.discard.orm", (Object[])new Object[0])), (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    public void doCancelAction() {
        this.storeDialogValues();
        if (this.askUserIfItsOkToCloseAndLoseEverything(false)) {
            super.doCancelAction();
        }
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetComponent.getChildComponent();
    }

    protected void dispose() {
        super.dispose();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/generation/ui/ImportMappingsDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("newEJBmap_to_datasource");
    }

    public String getPackageName() {
        return this.myPackageComponent.getText();
    }

    public String getEntityNameSuffix() {
        return this.myEntityNameSuffix;
    }

    public String getEntityNamePrefix() {
        return this.myEntityNamePrefix;
    }

    public boolean isGenerateSeparateXmlPerEntity() {
        return this.myCbGenerateSeparateXML.isSelected();
    }

    protected ValidationInfo doValidate() {
        String text = this.getDialogErrorText();
        if (text != null) {
            return new ValidationInfo(text);
        }
        return super.doValidate();
    }

    @Nullable
    public String getDialogErrorText() {
        if (StringUtil.isEmpty((String)((JTextField)this.myTargetComponent.getChildComponent()).getText())) {
            return JpaMessages.message((String)"ids.error.no.source.selected", (Object[])new Object[0]);
        }
        if (!this.myPsiNameHelper.isQualifiedName(this.myPackageComponent.getText())) {
            return JpaMessages.message((String)"ids.error.invalid.package", (Object[])new Object[]{this.myPackageComponent.getText()});
        }
        if (this.myCbGenerateSingleXml.isSelected()) {
            String mappingPath = this.myMappingName.getText();
            if (StringUtil.isEmpty((String)mappingPath) || LocalFileSystem.getInstance().findFileByPath(mappingPath) == null) {
                return JpaMessages.message((String)"ids.error.xml.mapping.file.invalid", (Object[])new Object[]{mappingPath});
            }
        } else if (!this.myCbGenerateAnnotations.isSelected() && !this.myCbGenerateSeparateXML.isSelected()) {
            return JpaMessages.message((String)"ids.error.no.mapping.selected", (Object[])new Object[0]);
        }
        if (!this.myPsiNameHelper.isIdentifier(this.myEntityNamePrefix + "_")) {
            return JpaMessages.message((String)"ids.error.inalid.entity.prefix", (Object[])new Object[]{this.myEntityNamePrefix});
        }
        if (!this.myPsiNameHelper.isIdentifier("_" + this.myEntityNameSuffix)) {
            return JpaMessages.message((String)"ids.error.inalid.entity.suffix", (Object[])new Object[]{this.myEntityNameSuffix});
        }
        if (this.myCbAddToUnit.isSelected() && StringUtil.isEmpty((String)((String)this.myCbUnits.getComboBox().getSelectedItem()))) {
            return JpaMessages.message((String)"ids.error.no.unit.selected", (Object[])new Object[0]);
        }
        return null;
    }

    private void restoreDialogValues() {
        GenerationSettings settings = GenerationSettings.getInstance();
        this.myTfEntityNamePrefix.setText(settings.getEntityPrefix());
        this.myTfEntityNameSuffix.setText(settings.getEntitySuffix());
        if (this.myCbGenerateAnnotations.isEnabled()) {
            this.myCbGenerateAnnotations.setSelected(settings.isGenerateAnnotations());
        }
        boolean generateSingle = settings.isGenerateSingleXml() && !settings.isGenerateSeparateXml();
        this.myCbGenerateSingleXml.setSelected(generateSingle);
        this.myCbGenerateSeparateXML.setSelected(settings.isGenerateSeparateXml());
        this.myMappingName.setEnabled(generateSingle);
        this.myCbAddToUnit.setSelected(settings.isAddToUnit());
        this.myCbUnits.setEnabled(settings.isAddToUnit());
    }

    private void storeDialogValues() {
        GenerationSettings settings = GenerationSettings.getInstance();
        settings.setEntityPrefix(this.myEntityNamePrefix);
        settings.setEntitySuffix(this.myEntityNameSuffix);
        settings.setGenerateAnnotations(this.myCbGenerateAnnotations.isSelected());
        settings.setGenerateSingleXml(this.myCbGenerateSingleXml.isSelected());
        settings.setGenerateSeparateXml(this.myCbGenerateSeparateXML.isSelected());
        settings.setAddToUnit(this.myCbAddToUnit.isSelected());
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(PACKAGE_RECENTS_KEY, this.myPackageComponent.getText());
    }

    private void setupControls() {
        this.setupTargetControls(this.myTargetLabel, this.myTargetComponent, this.myCaptionComponent);
        this.myPackageComponent = new PackageNameReferenceEditorCombo("", this.myProject, PACKAGE_RECENTS_KEY, JpaMessages.message((String)"dialog.title.choose.jpa.classes.package", (Object[])new Object[0]));
        this.myPackageLabel.setLabelFor((Component)this.myPackageComponent);
        this.myPackagePanel.add((Component)this.myPackageComponent, "Center");
        DatabaseSchemaImportDialog.setupMappingsAndUnitCombos(this.myFacet, this.myMappingName, this.myCbUnits, this.myUnitName, this.myCbAddToUnit);
        this.myCbGenerateSingleXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportMappingsDialog.this.myCbGenerateSeparateXML.setSelected(false);
                ImportMappingsDialog.this.myMappingName.setEnabled(ImportMappingsDialog.this.myCbGenerateSingleXml.isSelected());
                ImportMappingsDialog.this.myCbAddToUnit.setEnabled(ImportMappingsDialog.this.myUnitName == null);
            }
        });
        this.myCbGenerateSeparateXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImportMappingsDialog.this.myCbGenerateSingleXml.setSelected(false);
                ImportMappingsDialog.this.myMappingName.setEnabled(ImportMappingsDialog.this.myCbGenerateSingleXml.isSelected());
            }
        });
        boolean canHaveAnnos = LanguageLevel.JDK_1_5.compareTo((Enum)LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.myFacet.getModule())) <= 0;
        this.myCbGenerateAnnotations.setSelected(canHaveAnnos);
        this.myCbGenerateAnnotations.setEnabled(canHaveAnnos);
        DocumentAdapter suffixPrefixAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ImportMappingsDialog.this.myEntityNamePrefix = ImportMappingsDialog.this.myTfEntityNamePrefix.getText();
                ImportMappingsDialog.this.myEntityNameSuffix = ImportMappingsDialog.this.myTfEntityNameSuffix.getText();
            }
        };
        this.myTfEntityNamePrefix.setText(this.myEntityNamePrefix);
        this.myTfEntityNameSuffix.setText(this.myEntityNameSuffix);
        this.myTfEntityNamePrefix.getDocument().addDocumentListener((DocumentListener)suffixPrefixAdapter);
        this.myTfEntityNameSuffix.getDocument().addDocumentListener((DocumentListener)suffixPrefixAdapter);
        this.myTargetComponent.getTextField().getDocument().addDocumentListener((DocumentListener)suffixPrefixAdapter);
    }

    public PersistencePackage getPersistenceUnit() {
        Class<PersistenceUnit> aClass;
        if (this.myCbAddToUnit.isSelected()) {
            final String unitName = (String)this.myCbUnits.getComboBox().getSelectedItem();
            PersistencePackage unit = (PersistencePackage)ContainerUtil.find((Iterable)this.myFacet.getPersistenceUnits(), (Condition)new Condition<PersistencePackage>(){

                public boolean value(PersistencePackage o) {
                    return unitName.equals(o.getName().getValue());
                }
            });
            if (unit != null) {
                return unit;
            }
        }
        Class<PersistenceUnit> aClass1 = DomElement.class.isAssignableFrom(aClass = this.myFacet.getPersistenceUnitClass()) ? aClass : PersistenceUnit.class;
        return (PersistencePackage)DomManager.getDomManager((Project)this.myFacet.getModule().getProject()).createMockElement(aClass1, this.myFacet.getModule(), true);
    }

    @Nullable
    public PersistenceMappings getPersistenceMapping() {
        PersistenceMappings mappings;
        PersistenceMappings annoMappings;
        PersistenceMappings persistenceMappings = annoMappings = this.myCbGenerateAnnotations.isSelected() ? this.myFacet.getAnnotationEntityMappings() : null;
        if (this.myCbGenerateSingleXml.isSelected()) {
            String mappingFileName = this.myMappingName.getText();
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mappingFileName);
            PsiFile psiFile = file == null ? null : PsiManager.getInstance((Project)this.myFacet.getModule().getProject()).findFile(file);
            PersistenceMappings domMappings = (PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)psiFile, PersistenceMappings.class, (Module)this.myFacet.getModule());
            mappings = domMappings != null ? (annoMappings == null ? domMappings : (PersistenceMappings)DomService.getInstance().createModelMerger().mergeModels(PersistenceMappings.class, (Object[])new PersistenceMappings[]{domMappings, annoMappings})) : annoMappings;
        } else {
            mappings = annoMappings;
        }
        return mappings;
    }

    public void calcData(DataKey key, DataSink sink) {
        if (PersistenceDataKeys.PERSISTENCE_FACET == key) {
            sink.put(PersistenceDataKeys.PERSISTENCE_FACET, (Object)this.myFacet);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CaptionComponent captionComponent;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:5px:noGrow,fill:609px:grow,left:5px:noGrow", "fill:d:noGrow,top:4dlu:noGrow,fill:d:noGrow,top:4dlu:noGrow,fill:d:noGrow"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:max(d;4px):grow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:grow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel3, new CellConstraints(2, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.database.schema.import.generation"), (int)0, (int)0, null, null));
        this.myCbGenerateAnnotations = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.annotations"));
        jPanel3.add((Component)jCheckBox4, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbAddToUnit = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.add.to.unit"));
        jPanel3.add((Component)jCheckBox3, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new CellConstraints(5, 1, 3, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myMappingName = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        jPanel3.add((Component)textFieldWithBrowseButton2, new CellConstraints(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbUnits = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel3.add((Component)comboboxWithBrowseButton, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGenerateSeparateXML = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.separate.xml"));
        jPanel3.add((Component)jCheckBox2, new CellConstraints(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCbGenerateSingleXml = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/JpaBundle").getString("checkbox.database.schema.import.generate.single.xml"));
        jPanel3.add((Component)jCheckBox, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new FormLayout("left:5px:noGrow,fill:d:noGrow,left:4dlu:noGrow,fill:d:grow,left:4dlu:noGrow,fill:d:noGrow,left:4dlu:noGrow,fill:d:grow,left:5px:noGrow", "center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:d:noGrow"));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel2.add((Component)jPanel4, new CellConstraints(2, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/JpaBundle").getString("border.database.schema.import.general"), (int)0, (int)0, null, null));
        this.myTfEntityNameSuffix = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new CellConstraints(8, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.entity.suffix"));
        jPanel4.add((Component)jLabel3, new CellConstraints(6, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myPackageLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.package"));
        jPanel4.add((Component)jLabel2, new CellConstraints(2, 3, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/JpaBundle").getString("label.database.schema.import.entity.prefix"));
        jPanel4.add((Component)jLabel4, new CellConstraints(6, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTfEntityNamePrefix = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new CellConstraints(8, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("", ""));
        jPanel4.add((Component)jPanel5, new CellConstraints(2, 5, 7, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTargetLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel4.add((Component)jLabel, new CellConstraints(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myTargetComponent = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel4.add((Component)textFieldWithBrowseButton, new CellConstraints(4, 1, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myPackagePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new CellConstraints(4, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.myCaptionComponent = captionComponent = new CaptionComponent();
        captionComponent.setText(ResourceBundle.getBundle("messages/JpaBundle").getString("caption.database.schema.import.text"));
        captionComponent.setDescriptionText(ResourceBundle.getBundle("messages/JpaBundle").getString("caption.database.schema.import.description"));
        jPanel2.add((Component)captionComponent, new CellConstraints(2, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

