/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaQueryReferenceProvider;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import java.text.MessageFormat;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JpaQueryApiInspection
extends AbstractJpaInspection {
    @NonNls
    public static final String SHORT_NAME = "JpaQueryApiInspection";

    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.javaee.persistence.query.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                JpaQueryApiInspection.checkQueryApiReferences(expression, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/highlighting/JpaQueryApiInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkQueryApiReferences(PsiLiteralExpression literalExpression, ProblemsHolder holder, boolean isOnTheFly) {
        boolean badResolve;
        JpaQueryReferenceProvider.QueryRelatedReference relatedReference = JpaUtil.findReferenceOfType(literalExpression.getReferences(), JpaQueryReferenceProvider.QueryRelatedReference.class);
        boolean bl = badResolve = relatedReference != null && relatedReference.resolve() == null;
        if (badResolve) {
            String message = MessageFormat.format(relatedReference.getUnresolvedMessagePattern(), relatedReference.getCanonicalText());
            holder.registerProblem(holder.getManager().createProblemDescriptor(relatedReference.getElement(), relatedReference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, relatedReference.getQuickFixes()));
        }
    }
}

