/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.JavaeePersistenceORMResolveConverters;
import com.intellij.javaee.model.xml.persistence.mapping.AssociationOverride;
import com.intellij.javaee.model.xml.persistence.mapping.ColumnBase;
import com.intellij.javaee.model.xml.persistence.mapping.JoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.JoinTable;
import com.intellij.javaee.model.xml.persistence.mapping.PrimaryKeyJoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.SecondaryTable;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.ORMHelperRegistry;
import com.intellij.jpa.ORMReferencesUtil;
import com.intellij.jpa.highlighting.JpaDataSourceORMInspection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.persistence.model.TableInfoProvider;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ORMResolveConvertersImpl
implements Consumer<ORMHelperRegistry> {
    public void consume(ORMHelperRegistry helperRegistry) {
        helperRegistry.registerTableInfoProvider((NullableFunction<DomElement, Object>)((NullableFunction)domElement -> {
            DomElement parent = domElement.getParent();
            if (parent instanceof JoinColumn && ((JoinColumn)parent).getReferencedColumnName().equals(domElement)) {
                return ORMResolveConvertersImpl.getReferencedJoinColumnTableInfoProvider((JoinColumn)parent);
            }
            return null;
        }));
        helperRegistry.registerTableInfoProvider((NullableFunction<DomElement, Object>)((NullableFunction)domElement -> {
            DomElement parent = domElement.getParent();
            if (parent instanceof PrimaryKeyJoinColumn && ((PrimaryKeyJoinColumn)parent).getReferencedColumnName().equals(domElement)) {
                return ORMResolveConvertersImpl.getReferencedPrimaryKeyJoinColumnTableInfoProvider((PrimaryKeyJoinColumn)parent);
            }
            return null;
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static Object getReferencedJoinColumnTableInfoProvider(JoinColumn joinColumn) {
        boolean isTargetEntity;
        DomElement grandParent = joinColumn.getParent();
        if (grandParent instanceof JoinTable) {
            JoinTable joinTable = (JoinTable)grandParent;
            if (joinTable.getJoinColumns().contains(joinColumn)) {
                isTargetEntity = false;
            } else {
                if (!joinTable.getInverseJoinColumns().contains(joinColumn)) throw new AssertionError();
                isTargetEntity = true;
            }
        } else {
            isTargetEntity = true;
        }
        PersistentObject entity = ORMResolveConvertersImpl.getParentObject((DomElement)joinColumn);
        if (isTargetEntity) {
            PersistentAttribute attribute;
            if (grandParent instanceof AssociationOverride) {
                AssociationOverride associationOverride = (AssociationOverride)grandParent;
                PsiClass entityClass = entity != null ? (PsiClass)entity.getClazz().getValue() : null;
                String attributeName = (String)associationOverride.getName().getValue();
                attribute = attributeName == null ? null : (PersistentAttribute)ElementPresentationManager.findByName(ORMReferencesUtil.getPersistenceAttributes((PsiMember)entityClass, true), (String)attributeName);
            } else {
                attribute = ORMResolveConvertersImpl.getParentAttribute((DomElement)joinColumn);
            }
            if (!(attribute instanceof PersistentRelationshipAttribute)) return null;
            PsiClass psiClass = PersistenceCommonUtil.getTargetClass((PersistentRelationshipAttribute)((PersistentRelationshipAttribute)attribute));
            return psiClass;
        }
        PsiClass entityClass = entity == null ? null : (PsiClass)entity.getClazz().getValue();
        return entityClass != null ? entityClass : entity;
    }

    @Nullable
    public static Object getReferencedPrimaryKeyJoinColumnTableInfoProvider(PrimaryKeyJoinColumn joinColumn) {
        PersistentEntity result;
        DomElement grandParent = joinColumn.getParent();
        if (grandParent instanceof SecondaryTable) {
            result = ORMResolveConvertersImpl.getParentEntity((DomElement)joinColumn);
        } else {
            PsiMember member;
            PersistentAttribute attribute = ORMResolveConvertersImpl.getParentAttribute((DomElement)joinColumn);
            PersistentEntity entity = ORMResolveConvertersImpl.getParentEntity((DomElement)joinColumn);
            PsiMember psiMember = member = attribute == null ? null : attribute.getPsiMember();
            if (member == null) {
                PsiClass psiClass = entity == null ? null : (PsiClass)entity.getClazz().getValue();
                PsiClass resultTmp = null;
                if (psiClass != null) {
                    for (PsiClass curClass : JamCommonUtil.getSuperClassList((PsiClass)psiClass.getSuperClass())) {
                        ORMReferencesUtil.TableInfo tableInfoTmp = ORMResolveConvertersImpl.getEntityTableInfo((PsiElement)curClass, null);
                        if (tableInfoTmp == null) continue;
                        resultTmp = curClass;
                        break;
                    }
                }
                result = resultTmp;
            } else {
                PsiType psiType = PersistenceCommonUtil.getTargetEntityType((PsiMember)member);
                result = psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
            }
        }
        return result;
    }

    @Nullable
    private static PersistentAttribute getParentAttribute(DomElement element) {
        return (PersistentAttribute)DomUtil.getParentOfType((DomElement)element, PersistentAttribute.class, (boolean)false);
    }

    @Nullable
    private static PersistentEntity getParentEntity(DomElement element) {
        return (PersistentEntity)DomUtil.getParentOfType((DomElement)element, PersistentEntity.class, (boolean)false);
    }

    @Nullable
    private static PersistentObject getParentObject(DomElement element) {
        return (PersistentObject)DomUtil.getParentOfType((DomElement)element, PersistentObject.class, (boolean)false);
    }

    private static PersistenceMappings getEntityMappings(DomElement element) {
        DomElement root = DomUtil.getFileElement((DomElement)element).getRootElement();
        return root instanceof PersistenceMappings ? (PersistenceMappings)root : null;
    }

    @Nullable
    private static PersistencePackage getPersistentUnit(DomElement element) {
        DomElement domElement = DomUtil.getOriginalElement((DomElement)element);
        PersistencePackage unit = (PersistencePackage)DomUtil.getParentOfType((DomElement)domElement, PersistencePackage.class, (boolean)true);
        if (unit != null) {
            return unit;
        }
        XmlElement xmlElement = domElement.getXmlElement();
        while (xmlElement != null) {
            PersistencePackage ref = (PersistencePackage)xmlElement.getUserData(PersistencePackage.PERSISTENCE_UNIT_KEY);
            if (ref != null) {
                return ref;
            }
            xmlElement = xmlElement.getParent() instanceof XmlElement ? (XmlElement)xmlElement.getParent() : null;
        }
        return null;
    }

    private static LocalQuickFix[] getStandardQuickFixes(ConvertContext context) {
        PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(context.getInvocationElement());
        return JpaDataSourceORMInspection.createUnitDataSourceQuickFixes(entityMappings);
    }

    private static boolean shouldCheckResolve(ConvertContext context) {
        return PersistenceHelper.getHelper().getSharedModelBrowser().queryPersistenceFacets((PsiElement)context.getXmlElement()).findFirst() != null;
    }

    @Nullable
    public static ORMReferencesUtil.TableInfo getEntityTableInfo(PsiElement element, DomElement sourceElement) {
        return ORMResolveConvertersImpl.getEntityTableInfo(element, sourceElement, null);
    }

    @Nullable
    private static ORMReferencesUtil.TableInfo getEntityTableInfo(PsiElement element, DomElement sourceElement, String tableName) {
        if (element == null) {
            return null;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return null;
        }
        for (PersistentObject object : PersistenceCommonUtil.createSameUnitsModelBrowser((DomElement)sourceElement).queryPersistentObjects(psiClass)) {
            if (!(object instanceof PersistentEntity)) continue;
            return ORMReferencesUtil.getEntityTableInfo((PersistentEntity)object, tableName);
        }
        return null;
    }

    @Nullable
    private static ORMReferencesUtil.TableInfo getTableInfo(TableInfoProvider infoProvider) {
        String name = (String)infoProvider.getTableName().getValue();
        return name == null ? null : new ORMReferencesUtil.TableInfo(name, (String)infoProvider.getSchema().getValue(), (String)infoProvider.getCatalog().getValue());
    }

    private static Collection<LookupElement> setTailType(Collection<LookupElement> variantsCollection, GenericDomValue<String> domValue, TextRange rangeInElement) {
        XmlElement element = DomUtil.getValueElement(domValue);
        TextRange textRange = ElementManipulators.getManipulator((PsiElement)element).getRangeInElement((PsiElement)element);
        if (rangeInElement.getStartOffset() == textRange.getStartOffset()) {
            return variantsCollection;
        }
        String quote = element.getText().substring(textRange.getStartOffset(), rangeInElement.getStartOffset());
        return ORMReferencesUtil.setTailType(variantsCollection, quote);
    }

    public static class ColumnResolverImpl
    extends JavaeePersistenceORMResolveConverters.ColumnResolver {
        protected String getUnresolvedMessage(String value) {
            return JpaMessages.message((String)"cannot.resolve.column.0", (Object[])new Object[]{value});
        }

        @NotNull
        public static <T> List<T> getColumnVariants(DomElement element, Function<DbColumn, T> mapper) {
            ORMReferencesUtil.TableInfo tableInfo;
            PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(element);
            if (entityMappings == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$ColumnResolverImpl", "getColumnVariants"));
                }
                return list;
            }
            Object tableInfoProvider = ORMHelperRegistry.getRegistry().getTableInfoProvider(element);
            if (tableInfoProvider instanceof PersistentEntity) {
                tableInfo = ORMReferencesUtil.getEntityTableInfo((PersistentEntity)tableInfoProvider, null);
            } else if (tableInfoProvider instanceof PsiClass) {
                tableInfo = ORMResolveConvertersImpl.getEntityTableInfo((PsiElement)((PsiClass)tableInfoProvider), element);
            } else if (tableInfoProvider instanceof TableInfoProvider) {
                tableInfo = ORMResolveConvertersImpl.getTableInfo((TableInfoProvider)tableInfoProvider);
            } else {
                if (tableInfoProvider != null) {
                    throw new AssertionError(tableInfoProvider);
                }
                tableInfo = null;
            }
            List<T> list = ORMReferencesUtil.getColumnVariants(PersistenceUtil.getDataSources((PersistenceMappings)entityMappings), tableInfo, mapper);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$ColumnResolverImpl", "getColumnVariants"));
            }
            return list;
        }

        protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<String> genericDomValue, TextRange rangeInElement) {
            return ORMResolveConvertersImpl.setTailType(ContainerUtil.map2List(this.getReferenceVariantsCollection(context), ORMReferencesUtil.COLUMN_LOOKUP_MAPPER), (GenericDomValue<String>)genericDomValue, rangeInElement).toArray();
        }

        @NotNull
        public Collection<DbColumn> getReferenceVariantsCollection(ConvertContext context) {
            List<DbColumn> list = ColumnResolverImpl.getColumnVariants(context.getInvocationElement(), FunctionUtil.id());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$ColumnResolverImpl", "getReferenceVariantsCollection"));
            }
            return list;
        }

        @NotNull
        public ResolveResult[] multiResolveReference(String o, ConvertContext context) {
            if (!ORMResolveConvertersImpl.shouldCheckResolve(context)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)context.getReferenceXmlElement())};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$ColumnResolverImpl", "multiResolveReference"));
                }
                return resolveResultArray;
            }
            List<ResolveResult> result = ColumnResolverImpl.getColumnVariants(context.getInvocationElement(), fieldData -> {
                if (Comparing.equal((String)fieldData.getName(), (String)o, (boolean)false)) {
                    return new PsiElementResolveResult((PsiElement)fieldData);
                }
                return null;
            });
            ResolveResult[] resolveResultArray = result.size() == 0 ? ResolveResult.EMPTY_ARRAY : result.toArray(new ResolveResult[result.size()]);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$ColumnResolverImpl", "multiResolveReference"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes(ConvertContext context) {
            return ORMResolveConvertersImpl.getStandardQuickFixes(context);
        }
    }

    public static class SequenceResolverImpl
    extends JavaeePersistenceORMResolveConverters.SequenceResolver {
        protected String getUnresolvedMessage(String value) {
            return JpaMessages.message((String)"cannot.resolve.sequence.0", (Object[])new Object[]{value});
        }

        protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<String> genericDomValue, TextRange rangeInElement) {
            return ORMResolveConvertersImpl.setTailType(ContainerUtil.map2List(this.getReferenceVariantsCollection(context), ORMReferencesUtil.TABLE_LOOKUP_MAPPER), (GenericDomValue<String>)genericDomValue, rangeInElement).toArray();
        }

        @NotNull
        public Collection<DbTable> getTableVariants(ConvertContext context) {
            List tables;
            DomElement element = context.getInvocationElement();
            PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(element);
            if (entityMappings == null) {
                List<DbTable> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SequenceResolverImpl", "getTableVariants"));
                }
                return list;
            }
            DomElement parent = element.getParent();
            String schemaName = parent instanceof TableInfoProvider ? (String)((TableInfoProvider)parent).getSchema().getValue() : null;
            List list = tables = ContainerUtil.findAll(ORMReferencesUtil.getTableVariants(PersistenceUtil.getDataSources((PersistenceMappings)entityMappings), schemaName), databaseTableData -> Comparing.equal((Object)databaseTableData.getKind(), (Object)ObjectKind.SEQUENCE));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SequenceResolverImpl", "getTableVariants"));
            }
            return list;
        }

        @NotNull
        public Collection<DbTable> getReferenceVariantsCollection(ConvertContext context) {
            List list = ContainerUtil.map(this.getTableVariants(context), (Function)FunctionUtil.id());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SequenceResolverImpl", "getReferenceVariantsCollection"));
            }
            return list;
        }

        @NotNull
        public ResolveResult[] multiResolveReference(String o, ConvertContext context) {
            if (!ORMResolveConvertersImpl.shouldCheckResolve(context)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)context.getReferenceXmlElement())};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SequenceResolverImpl", "multiResolveReference"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults(this.getReferenceVariantsCollection(context), o);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SequenceResolverImpl", "multiResolveReference"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes(ConvertContext context) {
            return ORMResolveConvertersImpl.getStandardQuickFixes(context);
        }
    }

    public static class TableResolverImpl
    extends JavaeePersistenceORMResolveConverters.TableResolver {
        protected String getUnresolvedMessage(String value) {
            return JpaMessages.message((String)"cannot.resolve.table.0", (Object[])new Object[]{value});
        }

        protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<String> genericDomValue, TextRange rangeInElement) {
            return ORMResolveConvertersImpl.setTailType(ContainerUtil.map2List(this.getReferenceVariantsCollection(context), ORMReferencesUtil.TABLE_LOOKUP_MAPPER), (GenericDomValue<String>)genericDomValue, rangeInElement).toArray();
        }

        @NotNull
        public Collection<DbTable> getTableVariants(ConvertContext context) {
            Collection<DbTable> tables;
            DomElement element = context.getInvocationElement();
            PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(element);
            if (entityMappings == null) {
                List<DbTable> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$TableResolverImpl", "getTableVariants"));
                }
                return list;
            }
            DomElement parent = element.getParent();
            if (parent instanceof ColumnBase) {
                PersistentEntity parentEntity = ORMResolveConvertersImpl.getParentEntity(element);
                tables = parentEntity == null ? null : ORMReferencesUtil.getColumnTableVariants(PersistenceUtil.getDataSources((PersistenceMappings)entityMappings), Collections.singletonList(parentEntity), FunctionUtil.id());
            } else {
                String schemaName = parent instanceof TableInfoProvider ? (String)((TableInfoProvider)parent).getSchema().getValue() : null;
                tables = ORMReferencesUtil.getTableVariants(PersistenceUtil.getDataSources((PersistenceMappings)entityMappings), schemaName);
            }
            Collection<Object> collection = tables == null ? Collections.emptyList() : tables;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$TableResolverImpl", "getTableVariants"));
            }
            return collection;
        }

        @NotNull
        public Collection<DbTable> getReferenceVariantsCollection(ConvertContext context) {
            Collection<DbTable> collection = this.getTableVariants(context);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$TableResolverImpl", "getReferenceVariantsCollection"));
            }
            return collection;
        }

        @NotNull
        public ResolveResult[] multiResolveReference(String o, ConvertContext context) {
            if (!ORMResolveConvertersImpl.shouldCheckResolve(context)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)context.getReferenceXmlElement())};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$TableResolverImpl", "multiResolveReference"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults(this.getReferenceVariantsCollection(context), o);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$TableResolverImpl", "multiResolveReference"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes(ConvertContext context) {
            return ORMResolveConvertersImpl.getStandardQuickFixes(context);
        }
    }

    public static class SchemaResolverImpl
    extends JavaeePersistenceORMResolveConverters.SchemaResolver {
        protected String getUnresolvedMessage(String value) {
            return JpaMessages.message((String)"cannot.resolve.schema.0", (Object[])new Object[]{value});
        }

        protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<String> genericDomValue, TextRange rangeInElement) {
            return ORMResolveConvertersImpl.setTailType(ContainerUtil.map2List(this.getReferenceVariantsCollection(context), ORMReferencesUtil.SCHEMA_LOOKUP_MAPPER), (GenericDomValue<String>)genericDomValue, rangeInElement).toArray();
        }

        @NotNull
        public Collection<DbElement> getReferenceVariantsCollection(ConvertContext context) {
            String tableName;
            List<DbDataSource> dataSources;
            DomElement element = context.getInvocationElement();
            PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(element);
            if (entityMappings == null) {
                PersistencePackage unit = ORMResolveConvertersImpl.getPersistentUnit(element);
                dataSources = unit == null ? Collections.emptyList() : PersistenceUtil.getDataSources((Project)element.getManager().getProject(), Collections.singletonList(unit));
                tableName = null;
            } else {
                DomElement parent = element.getParent();
                tableName = parent instanceof TableInfoProvider ? (String)((TableInfoProvider)parent).getTableName().getValue() : null;
                dataSources = PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
            }
            Collection<DbElement> collection = ORMReferencesUtil.getSchemaVariants(dataSources, tableName);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SchemaResolverImpl", "getReferenceVariantsCollection"));
            }
            return collection;
        }

        @NotNull
        public ResolveResult[] multiResolveReference(String o, ConvertContext context) {
            if (!ORMResolveConvertersImpl.shouldCheckResolve(context)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)context.getReferenceXmlElement())};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SchemaResolverImpl", "multiResolveReference"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults(this.getReferenceVariantsCollection(context), o);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$SchemaResolverImpl", "multiResolveReference"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes(ConvertContext context) {
            return ORMResolveConvertersImpl.getStandardQuickFixes(context);
        }
    }

    public static class CatalogResolverImpl
    extends JavaeePersistenceORMResolveConverters.CatalogResolver {
        protected String getUnresolvedMessage(String value) {
            return JpaMessages.message((String)"cannot.resolve.catalog.0", (Object[])new Object[]{value});
        }

        protected Object[] getReferenceVariants(ConvertContext context, GenericDomValue<String> genericDomValue, TextRange rangeInElement) {
            return ORMResolveConvertersImpl.setTailType(ContainerUtil.map2List(this.getReferenceVariantsCollection(context), ORMReferencesUtil.CATALOG_LOOKUP_MAPPER), (GenericDomValue<String>)genericDomValue, rangeInElement).toArray();
        }

        @NotNull
        public Collection<DbElement> getReferenceVariantsCollection(ConvertContext context) {
            PersistencePackage unit;
            DomElement element = context.getInvocationElement();
            PersistenceMappings entityMappings = ORMResolveConvertersImpl.getEntityMappings(element);
            Collection<Object> dataSources = entityMappings == null ? ((unit = ORMResolveConvertersImpl.getPersistentUnit(element)) == null ? Collections.emptyList() : PersistenceUtil.getDataSources((Project)element.getManager().getProject(), Collections.singletonList(unit))) : PersistenceUtil.getDataSources((PersistenceMappings)entityMappings);
            Collection<DbElement> collection = ORMReferencesUtil.getCatalogVariants((Collection<DbDataSource>)dataSources);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$CatalogResolverImpl", "getReferenceVariantsCollection"));
            }
            return collection;
        }

        @NotNull
        public ResolveResult[] multiResolveReference(String o, ConvertContext context) {
            if (!ORMResolveConvertersImpl.shouldCheckResolve(context)) {
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)context.getReferenceXmlElement())};
                if (resolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$CatalogResolverImpl", "multiResolveReference"));
                }
                return resolveResultArray;
            }
            ResolveResult[] resolveResultArray = ORMReferencesUtil.getDbElementResolveResults(this.getReferenceVariantsCollection(context), o);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/model/xml/impl/converters/ORMResolveConvertersImpl$CatalogResolverImpl", "multiResolveReference"));
            }
            return resolveResultArray;
        }

        public LocalQuickFix[] getQuickFixes(ConvertContext context) {
            return ORMResolveConvertersImpl.getStandardQuickFixes(context);
        }
    }
}

