/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.view.tree.JamNodeDescriptor;
import com.intellij.jam.view.tree.JamTreeParameters;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.javaee.module.view.nodes.FileNodeDescriptor;
import com.intellij.jpa.view.nodes.EntityListenerNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistenceNodeDescriptor;
import com.intellij.jpa.view.nodes.PersistentObjectNodeDescriptor;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import java.util.ArrayList;
import javax.swing.Icon;

public class PersistenceUnitNodeDescriptor
extends PersistenceNodeDescriptor<PersistencePackage> {
    public PersistenceUnitNodeDescriptor(PersistencePackage unit, NodeDescriptor parentDescriptor, Object parameters) {
        super(unit, parentDescriptor, parameters);
    }

    public PersistenceUnitNodeDescriptor(PersistencePackage unit, Object parameters) {
        super(unit, unit.getPsiManager().getProject(), parameters);
    }

    public JamNodeDescriptor[] getChildren() {
        PersistenceMappings entityMappings;
        JamTreeParameters parameters = (JamTreeParameters)this.getParameters();
        if (!parameters.showMembers()) {
            return JamNodeDescriptor.EMPTY_ARRAY;
        }
        ArrayList<Object> children = new ArrayList<Object>();
        PersistencePackage unit = (PersistencePackage)this.getElement();
        if (!unit.isValid()) {
            return JamNodeDescriptor.EMPTY_ARRAY;
        }
        PersistenceFacet facet = this.getParentElementOfType(PersistenceFacet.class);
        PersistenceMappings persistenceMappings = entityMappings = facet == null ? null : facet.getEntityMappings(unit);
        if (entityMappings == null) {
            for (GenericValue domMapping : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                FileNodeDescriptor nodeDescriptor;
                PersistenceMappings mappings = (PersistenceMappings)domMapping.getValue();
                PsiFile file = mappings != null ? mappings.getContainingFile() : null;
                if (file == null || !parameters.isNodeEnabled((NodeDescriptor)(nodeDescriptor = this.createFileDescriptor(parameters, file)))) continue;
                children.add((Object)nodeDescriptor);
            }
        } else {
            for (PersistenceMappings mappings : ModelMergerUtil.getFilteredImplementations((Object)entityMappings)) {
                FileNodeDescriptor nodeDescriptor;
                PsiFile file = mappings.getContainingFile();
                if (file == null || !parameters.isNodeEnabled((NodeDescriptor)(nodeDescriptor = this.createFileDescriptor(parameters, file)))) continue;
                children.add((Object)nodeDescriptor);
            }
        }
        if (entityMappings != null) {
            PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)entityMappings).forEach(persistentObject -> {
                PersistentObjectNodeDescriptor<PersistentObject> nodeDescriptor = new PersistentObjectNodeDescriptor<PersistentObject>((PersistentObject)persistentObject, (NodeDescriptor)this, (Object)parameters);
                if (parameters.isNodeEnabled(nodeDescriptor)) {
                    children.add(nodeDescriptor);
                }
                return true;
            });
            for (PersistenceListener child : entityMappings.getModelHelper().getPersistentListeners()) {
                EntityListenerNodeDescriptor nodeDescriptor;
                if (!(child instanceof EntityListener) || !parameters.isNodeEnabled((NodeDescriptor)(nodeDescriptor = new EntityListenerNodeDescriptor((EntityListener)child, (NodeDescriptor)this, (Object)parameters)))) continue;
                children.add((Object)nodeDescriptor);
            }
        }
        return children.toArray(new JamNodeDescriptor[children.size()]);
    }

    private FileNodeDescriptor createFileDescriptor(JamTreeParameters parameters, PsiFile file) {
        return new FileNodeDescriptor(file, (NodeDescriptor)this, parameters){

            @Override
            public int getWeight() {
                return 0;
            }
        };
    }

    public int getWeight() {
        return 20;
    }

    @Override
    public Object getData(String dataId) {
        if (PersistenceDataKeys.PERSISTENCE_UNIT.is(dataId) || PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.is(dataId)) {
            return this.getElement();
        }
        if (PersistenceDataKeys.PERSISTENCE_FACET.is(dataId)) {
            return this.getParentElementOfType(PersistenceFacet.class);
        }
        return super.getData(dataId);
    }

    public String getNewNodeText() {
        if (!((PersistencePackage)this.getElement()).isValid()) {
            return null;
        }
        return (String)((PersistencePackage)this.getElement()).getName().getValue();
    }

    public Icon getNewIcon() {
        return ElementPresentationManager.getIcon((Object)this.getElement());
    }
}

