/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.inspections;

import com.intellij.batch.model.job.BatchNextStepsOwner;
import com.intellij.batch.model.job.CheckpointPolicy;
import com.intellij.batch.model.job.Chunk;
import com.intellij.batch.model.job.Identified;
import com.intellij.batch.model.job.Job;
import com.intellij.batch.model.job.Next;
import com.intellij.batch.model.job.Step;
import com.intellij.batch.resources.BatchBundle;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BatchJobDomInspection
extends BasicDomElementsInspection<Job> {
    public BatchJobDomInspection() {
        super(Job.class, new Class[0]);
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        super.checkDomElement(element, holder, helper);
        if (element instanceof BatchNextStepsOwner) {
            BatchJobDomInspection.checkNextSteps((BatchNextStepsOwner)element, holder);
        }
        if (element instanceof Chunk) {
            BatchJobDomInspection.checkChunk((Chunk)element, holder);
        }
        if (element instanceof Step) {
            this.checkStep((Step)element, holder);
        }
    }

    private void checkStep(@NotNull Step step, @NotNull DomElementAnnotationHolder holder) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/batch/inspections/BatchJobDomInspection", "checkStep"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/batch/inspections/BatchJobDomInspection", "checkStep"));
        }
        if (DomUtil.hasXml((DomElement)step.getChunk()) && DomUtil.hasXml((DomElement)step.getBatchlet())) {
            holder.createProblem((DomElement)step, HighlightSeverity.WARNING, BatchBundle.message("chunk.and.batchlet.not.allowed", new Object[0]));
        }
    }

    private static void checkChunk(@NotNull Chunk chunk, @NotNull DomElementAnnotationHolder holder) {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/batch/inspections/BatchJobDomInspection", "checkChunk"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/batch/inspections/BatchJobDomInspection", "checkChunk"));
        }
        CheckpointPolicy policy = (CheckpointPolicy)((Object)chunk.getCheckpointPolicy().getValue());
        if (policy == CheckpointPolicy.CUSTOM && !DomUtil.hasXml((DomElement)chunk.getCheckpointAlgorithm())) {
            holder.createProblem(chunk.getCheckpointPolicy(), HighlightSeverity.WARNING, BatchBundle.message("required.checkpoint.algorithm", new Object[0]));
        }
        if (policy == CheckpointPolicy.ITEM && DomUtil.hasXml((DomElement)chunk.getCheckpointAlgorithm())) {
            holder.createProblem(chunk.getCheckpointPolicy(), HighlightSeverity.WARNING, BatchBundle.message("redundant.checkpoint.algorithm", new Object[0]));
        }
    }

    private static void checkNextSteps(@NotNull BatchNextStepsOwner step, @NotNull DomElementAnnotationHolder holder) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/batch/inspections/BatchJobDomInspection", "checkNextSteps"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/batch/inspections/BatchJobDomInspection", "checkNextSteps"));
        }
        String jobId = step.getId().getStringValue();
        if (jobId != null) {
            GenericAttributeValue<Identified> stepNext = step.getNext();
            if (jobId.equals(stepNext.getStringValue())) {
                BatchJobDomInspection.addSelfReferenceProblem(holder, stepNext);
            }
            for (Next next : step.getNexts()) {
                GenericAttributeValue<Identified> to = next.getTo();
                if (!jobId.equals(to.getStringValue())) continue;
                BatchJobDomInspection.addSelfReferenceProblem(holder, to);
            }
        }
    }

    private static void addSelfReferenceProblem(DomElementAnnotationHolder holder, GenericAttributeValue stepNext) {
        holder.createProblem((DomElement)stepNext, HighlightSeverity.WARNING, BatchBundle.message("self.reference.is.prohibited", new Object[0]));
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = BatchBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/BatchJobDomInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BatchBundle.message("job.xml.config.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/BatchJobDomInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/inspections/BatchJobDomInspection", "getShortName"));
        }
        return string;
    }
}

