/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.model;

import com.intellij.batch.model.batch.BatchArtifactRef;
import com.intellij.cdi.jam.CdiNamedBean;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.xml.util.PsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BatchArtifactRefBean<T>
implements PsiElementPointer {
    @Nullable
    public abstract String getName();

    @Nullable
    public abstract PsiType getType();

    public abstract T getWrapped();

    public static class BATCH_ARTIFACT_REF
    extends BatchArtifactRefBean<BatchArtifactRef> {
        @NotNull
        private final BatchArtifactRef myRef;

        public BATCH_ARTIFACT_REF(@NotNull BatchArtifactRef ref) {
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/batch/model/BatchArtifactRefBean$BATCH_ARTIFACT_REF", "<init>"));
            }
            this.myRef = ref;
        }

        @Override
        @Nullable
        public String getName() {
            return this.myRef.getId().getStringValue();
        }

        @Override
        @Nullable
        public PsiType getType() {
            PsiClass aClass = (PsiClass)this.myRef.getClazz().getValue();
            return aClass == null ? null : JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
        }

        @Override
        public BatchArtifactRef getWrapped() {
            return this.myRef;
        }

        @Nullable
        public PsiElement getPsiElement() {
            DomTarget target = DomTarget.getTarget((DomElement)this.myRef);
            return target != null ? PomService.convertToPsi((PsiTarget)target) : null;
        }
    }

    public static class NAMED_BEAN
    extends BatchArtifactRefBean<CdiNamedBean> {
        @NotNull
        private final CdiNamedBean myBean;

        public NAMED_BEAN(@NotNull CdiNamedBean bean) {
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/batch/model/BatchArtifactRefBean$NAMED_BEAN", "<init>"));
            }
            this.myBean = bean;
        }

        @Override
        @Nullable
        public String getName() {
            return this.myBean.getName();
        }

        @Override
        @Nullable
        public PsiType getType() {
            return this.myBean.getType();
        }

        @Override
        public CdiNamedBean getWrapped() {
            return this.myBean;
        }

        @Nullable
        public PsiElement getPsiElement() {
            return this.myBean.getIdentifyingPsiElement();
        }
    }
}

