/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.references;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.batch.model.job.Job;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BatchJobReference
extends PsiReferenceBase<PsiElement> {
    public BatchJobReference(PsiLiteral element) {
        this(element, ElementManipulators.getManipulator((PsiElement)element).getRangeInElement((PsiElement)element));
    }

    public BatchJobReference(PsiLiteral element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            for (BatchJobXmlModel jobXmlModel : BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchJobModels(module)) {
                Job job = jobXmlModel.getJob();
                String jobName = job.getId().getStringValue();
                if (!value.equals(jobName)) continue;
                return job.getXmlElement();
            }
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/batch/references/BatchJobReference", "bindToElement"));
        }
        return this.getElement();
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            List<BatchJobXmlModel> models = BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchJobModels(module);
            for (BatchJobXmlModel jobXmlModel : models) {
                Job job = jobXmlModel.getJob();
                String jobName = job.getId().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)jobName)) continue;
                XmlElement element = job.getXmlElement();
                String fileName = "";
                if (element != null) {
                    fileName = element.getContainingFile().getName();
                }
                lookups.add(LookupElementBuilder.create((String)jobName).withTypeText(fileName));
            }
        }
        Object[] objectArray = ArrayUtil.toObjectArray(lookups);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/references/BatchJobReference", "getVariants"));
        }
        return objectArray;
    }
}

