/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi.util.processors;

import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.plugins.drools.lang.psi.util.processors.DroolsDeclarationsProcessor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.annotations.NotNull;

public class DroolsImportedPackagesProcessor
implements DroolsDeclarationsProcessor {
    private static DroolsImportedPackagesProcessor myInstance;

    private DroolsImportedPackagesProcessor() {
    }

    public static DroolsImportedPackagesProcessor getInstance() {
        if (myInstance == null) {
            myInstance = new DroolsImportedPackagesProcessor();
        }
        return myInstance;
    }

    @Override
    public boolean processElement(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place, @NotNull DroolsFile droolsFile) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedPackagesProcessor", "processElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedPackagesProcessor", "processElement"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedPackagesProcessor", "processElement"));
        }
        if (droolsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsFile", "com/intellij/plugins/drools/lang/psi/util/processors/DroolsImportedPackagesProcessor", "processElement"));
        }
        for (PsiPackage psiPackage : DroolsResolveUtil.getDefaultPackages(droolsFile)) {
            if (psiPackage == null || psiPackage.processDeclarations(processor, state, lastParent, place)) continue;
            return false;
        }
        for (PsiPackage psiPackage : DroolsResolveUtil.getExplicitlyImportedPackages(droolsFile)) {
            if (psiPackage == null) continue;
            if (!psiPackage.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            for (PsiClass aClass : psiPackage.getClasses()) {
                if (aClass.processDeclarations(processor, state, lastParent, place)) continue;
                return false;
            }
        }
        return true;
    }
}

