/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.structure;

import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.plugins.drools.lang.psi.DroolsFile;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsGlobalStatement;
import com.intellij.plugins.drools.lang.psi.DroolsPsiCompositeElement;
import com.intellij.plugins.drools.lang.psi.DroolsRuleStatement;
import com.intellij.plugins.drools.structure.DroolsFunctionStatementStructureViewElement;
import com.intellij.plugins.drools.structure.DroolsGlobalVariableStructureViewElement;
import com.intellij.plugins.drools.structure.DroolsRuleStatementStructureViewElement;
import com.intellij.plugins.drools.structure.DroolsStructureViewElement;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class DroolsFileStructureViewElement
extends DroolsStructureViewElement {
    private DroolsFile myPsiFile;

    public DroolsFileStructureViewElement(DroolsFile psiFile) {
        super((PsiElement)psiFile);
        this.myPsiFile = psiFile;
    }

    @NotNull
    public TreeElement[] getChildren() {
        ArrayList<DroolsStructureViewElement> result = new ArrayList<DroolsStructureViewElement>();
        for (DroolsGlobalStatement droolsGlobalStatement : this.myPsiFile.getGlobalVariables()) {
            result.add(new DroolsGlobalVariableStructureViewElement(droolsGlobalStatement));
        }
        for (DroolsPsiCompositeElement droolsPsiCompositeElement : this.myPsiFile.getRules()) {
            result.add(new DroolsRuleStatementStructureViewElement((DroolsRuleStatement)droolsPsiCompositeElement));
        }
        for (DroolsPsiCompositeElement droolsPsiCompositeElement : this.myPsiFile.getFunctions()) {
            result.add(new DroolsFunctionStatementStructureViewElement((DroolsFunctionStatement)droolsPsiCompositeElement));
        }
        TreeElement[] treeElementArray = result.toArray(new TreeElement[result.size()]);
        if (treeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/structure/DroolsFileStructureViewElement", "getChildren"));
        }
        return treeElementArray;
    }

    public String getPresentableText() {
        ItemPresentation presentation = this.myPsiFile.getPresentation();
        return presentation == null ? null : presentation.getPresentableText();
    }

    public String getLocationString() {
        ItemPresentation presentation = this.myPsiFile.getPresentation();
        return presentation == null ? null : presentation.getLocationString();
    }

    public Icon getIcon(boolean unused) {
        ItemPresentation presentation = this.myPsiFile.getPresentation();
        return presentation == null ? null : presentation.getIcon(unused);
    }
}

