/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.externalizable.documentation.generationchain;

import com.intellij.tapestry.core.model.externalizable.documentation.Home;
import com.intellij.tapestry.core.model.externalizable.documentation.generationchain.AbstractDocumentationGenerator;
import com.intellij.tapestry.core.model.externalizable.documentation.generationchain.DocumentationGenerationContext;
import com.intellij.tapestry.core.model.externalizable.documentation.wrapper.PresentationElementDocumentationWrapper;
import com.intellij.tapestry.core.util.ClassLocator;
import com.intellij.tapestry.core.util.VelocityProcessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.chain.Context;

public class HomeDocumentationGenerator
extends AbstractDocumentationGenerator {
    private static final String VELOCITY_TEMPLATE = "/documentation/home.vm";
    private static final String[] DOCUMENTATION_ELEMENT_TYPES = new String[]{"components", "pages", "mixins"};

    @Override
    public boolean execute(Context context) throws Exception {
        if (!super.execute(context)) {
            return false;
        }
        DocumentationGenerationContext myContext = (DocumentationGenerationContext)context;
        if (!(myContext.getElement() instanceof Home)) {
            return false;
        }
        Home element = (Home)myContext.getElement();
        Map<String, Object> velocityContext = this.buildVelocityContext();
        velocityContext.put("modules", element.getTapestryProjects());
        for (String elementType : DOCUMENTATION_ELEMENT_TYPES) {
            List<ClassLocator.ClassLocation> resources;
            HashMap<String, String> filesProperties = new HashMap<String, String>();
            try {
                ClassLocator locator = new ClassLocator(this.getClass().getClassLoader(), "documentation.core." + elementType);
                resources = locator.getAllClassLocations();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (resources == null) continue;
            for (ClassLocator.ClassLocation resource : resources) {
                if (!resource.getUrl().toExternalForm().endsWith(".xml")) continue;
                PresentationElementDocumentationWrapper elementDocumentation = new PresentationElementDocumentationWrapper(resource.getUrl());
                String description = elementDocumentation.getDescription();
                String truncated = description.length() < 100 ? description : description.substring(0, description.substring(0, 100).lastIndexOf(32));
                filesProperties.put(resource.getClassName(), truncated + "(...)");
            }
            velocityContext.put(elementType, filesProperties);
        }
        myContext.setResult(VelocityProcessor.processClasspathTemplate(VELOCITY_TEMPLATE, velocityContext));
        return true;
    }
}

