/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.actions.createnew;

import com.intellij.javaee.web.WebRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.tapestry.intellij.TapestryModuleSupportLoader;
import com.intellij.tapestry.intellij.util.IdeaUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AddNewComponentDialog
extends JDialog {
    private JPanel _contentPane;
    private JTextField _name;
    private JComboBox _templateSourceDirectoryCombo;
    private JComboBox _classSourceDirectoryCombo;
    private JCheckBox _replaceExistingFilesCheck;
    private JCheckBox _createTemplateCheck;

    public AddNewComponentDialog(Module module, String selectedPackage, boolean isPage) {
        SourceFolder[] sourceFolders;
        String newClassesSourceDirectory;
        String newTemplatesSourceDirectory;
        this.$$$setupUI$$$();
        this.setContentPane(this._contentPane);
        this.setModal(true);
        this._name.setText(selectedPackage);
        this._name.putClientProperty(DialogWrapperPeer.HAVE_INITIAL_SELECTION, Boolean.FALSE);
        if (isPage) {
            newTemplatesSourceDirectory = TapestryModuleSupportLoader.getInstance(module).getState().getNewPagesTemplatesSourceDirectory();
            newClassesSourceDirectory = TapestryModuleSupportLoader.getInstance(module).getState().getNewPagesClassesSourceDirectory();
        } else {
            newTemplatesSourceDirectory = TapestryModuleSupportLoader.getInstance(module).getState().getNewComponentsTemplatesSourceDirectory();
            newClassesSourceDirectory = TapestryModuleSupportLoader.getInstance(module).getState().getNewComponentsClassesSourceDirectory();
        }
        for (SourceFolder sourceFolder : sourceFolders = ModuleRootManager.getInstance((Module)module).getContentEntries()[0].getSourceFolders()) {
            if (sourceFolder.getFile() == null) continue;
            RootFolderWrapper folderWrapper = new RootFolderWrapper(sourceFolder);
            this._templateSourceDirectoryCombo.addItem(folderWrapper);
            if (folderWrapper.toString().equals(newTemplatesSourceDirectory)) {
                this._templateSourceDirectoryCombo.setSelectedItem(folderWrapper);
            }
            this._classSourceDirectoryCombo.addItem(folderWrapper);
            if (!folderWrapper.toString().equals(newClassesSourceDirectory)) continue;
            this._classSourceDirectoryCombo.setSelectedItem(folderWrapper);
        }
        List<WebRoot> webRoots = IdeaUtils.findWebRoots(module);
        for (WebRoot webRoot : webRoots) {
            if (webRoot.getFile() == null) continue;
            RootFolderWrapper folderWrapper = new RootFolderWrapper(webRoot);
            if (isPage) {
                this._templateSourceDirectoryCombo.addItem(folderWrapper);
            }
            if (!folderWrapper.toString().equals(newTemplatesSourceDirectory)) continue;
            this._templateSourceDirectoryCombo.setSelectedItem(folderWrapper);
        }
        this._createTemplateCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddNewComponentDialog.this.setNotCreatingTemplate(!AddNewComponentDialog.this._createTemplateCheck.isSelected());
            }
        });
    }

    @Override
    public JPanel getContentPane() {
        return this._contentPane;
    }

    @Override
    public String getName() {
        return this._name.getText();
    }

    public boolean isReplaceExistingFiles() {
        return this._replaceExistingFilesCheck.isSelected();
    }

    public boolean isNotCreatingTemplate() {
        return this._createTemplateCheck.isSelected();
    }

    public void setNotCreatingTemplate(boolean enabled) {
        this._templateSourceDirectoryCombo.setEnabled(enabled);
    }

    public VirtualFile getTemplateSourceDirectory() {
        return ((RootFolderWrapper)this._templateSourceDirectoryCombo.getSelectedItem()).getFolder();
    }

    public VirtualFile getClassSourceDirectory() {
        return ((RootFolderWrapper)this._classSourceDirectoryCombo.getSelectedItem()).getFolder();
    }

    public JComponent getNameComponent() {
        return this._name;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JTextField jTextField;
        JPanel jPanel;
        this._contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this._name = jTextField = new JTextField();
        jTextField.setToolTipText("You can use \"/\" to add a path to the name. (ex: \"public/Login\")");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Template source directory:");
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this._templateSourceDirectoryCombo = jComboBox2 = new JComboBox();
        ((Component)jComboBox2).setEnabled(true);
        jPanel2.add(jComboBox2, new GridConstraints(2, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Class source directory:");
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this._classSourceDirectoryCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this._replaceExistingFilesCheck = jCheckBox2 = new JCheckBox();
        jCheckBox2.setToolTipText("If the generated class or template exists should they be replaced ?");
        jCheckBox2.setText("Replace existing files");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this._createTemplateCheck = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Do not create template");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this._contentPane;
    }

    class RootFolderWrapper {
        SourceFolder _javaRootFolder;
        WebRoot _webRootFolder;

        RootFolderWrapper(SourceFolder javaRootFolder) {
            this._javaRootFolder = javaRootFolder;
        }

        RootFolderWrapper(WebRoot webRootFolder) {
            this._webRootFolder = webRootFolder;
        }

        public VirtualFile getFolder() {
            return this._javaRootFolder != null ? this._javaRootFolder.getFile() : this._webRootFolder.getFile();
        }

        public String toString() {
            return this._javaRootFolder != null ? this._javaRootFolder.getFile().getPath() : this._webRootFolder.getFile().getPath();
        }
    }
}

