/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.editorActions;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.tapestry.intellij.util.TapestryPropertyNamingUtil;
import com.intellij.tapestry.lang.TmlFileType;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class TapestryMethodReferenceSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public TapestryMethodReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters parameters, @NotNull Processor<PsiReference> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/tapestry/intellij/editorActions/TapestryMethodReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/tapestry/intellij/editorActions/TapestryMethodReferenceSearcher", "processQuery"));
        }
        PsiMethod method = parameters.getMethod();
        String propName = TapestryPropertyNamingUtil.getPropertyNameFromAccessor(method);
        SearchScope searchScope = parameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{TmlFileType.INSTANCE});
        }
        if (!StringUtil.isEmpty((String)propName)) {
            parameters.getOptimizer().searchWord(propName, searchScope, (short)8, false, (PsiElement)method);
        }
        parameters.getOptimizer().searchWord(method.getName(), searchScope, (short)8, false, (PsiElement)method);
    }
}

