/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.util;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Filter;
import com.intellij.javaee.model.xml.web.FilterMapping;
import com.intellij.javaee.model.xml.web.WebApp;

public class IntellijWebDescriptorUtils {
    public static Filter getTapestryFilter(WebApp app) {
        if (app == null) {
            return null;
        }
        for (Filter filter : app.getFilters()) {
            if (!filter.getFilterClass().getStringValue().equals("org.apache.tapestry5.TapestryFilter")) continue;
            return filter;
        }
        return null;
    }

    public static String getApplicationPackage(WebApp app) {
        if (app == null) {
            return null;
        }
        for (ParamValue param : app.getContextParams()) {
            if (!((String)param.getParamName().getValue()).equals("tapestry.app-package")) continue;
            return (String)param.getParamValue().getValue();
        }
        return null;
    }

    public static void setApplicationPackage(WebApp app, String applicationPackage) {
        if (app == null) {
            return;
        }
        String configuredApplicationPackage = IntellijWebDescriptorUtils.getApplicationPackage(app);
        if (configuredApplicationPackage == null) {
            ParamValue newContextParam = app.addContextParam();
            newContextParam.getParamName().setValue((Object)"tapestry.app-package");
            newContextParam.getParamValue().setValue((Object)(applicationPackage != null ? applicationPackage : ""));
        } else {
            for (ParamValue param : app.getContextParams()) {
                if (!((String)param.getParamName().getValue()).equals("tapestry.app-package")) continue;
                param.getParamValue().setValue((Object)applicationPackage);
            }
        }
    }

    public static void updateFilter(WebApp app, String filterName) {
        if (app == null) {
            return;
        }
        Filter existingFilter = IntellijWebDescriptorUtils.getTapestryFilter(app);
        String existingFilterName = null;
        if (existingFilter != null) {
            existingFilterName = (String)existingFilter.getFilterName().getValue();
            existingFilter.getFilterName().setValue((Object)filterName);
        } else {
            Filter newFilter = app.addFilter();
            newFilter.getFilterName().setValue((Object)filterName);
            newFilter.getFilterClass().setStringValue("org.apache.tapestry5.TapestryFilter");
        }
        if (existingFilterName != null) {
            for (FilterMapping filterMapping : app.getFilterMappings()) {
                if (!filterMapping.getFilterName().getStringValue().equals(existingFilterName)) continue;
                filterMapping.getFilterName().setStringValue(filterName);
            }
        } else {
            FilterMapping newFilterMapping = app.addFilterMapping();
            newFilterMapping.getFilterName().setStringValue(filterName);
            newFilterMapping.addUrlPattern().setValue((Object)"/*");
        }
    }
}

