/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.artifacts;

import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class WithModulePackagingElementPresentation
extends PackagingElementPresentation {
    private final String myModuleId;
    private final String myResourceKey;
    private final Icon myIcon;

    public WithModulePackagingElementPresentation(String moduleId, @PropertyKey(resourceBundle="com.intellij.dmserver.util.DmServer") String resourceKey, Icon icon) {
        this.myModuleId = moduleId;
        this.myResourceKey = resourceKey;
        this.myIcon = icon;
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/dmserver/artifacts/WithModulePackagingElementPresentation", "render"));
        }
        presentationData.setIcon(this.myIcon);
        presentationData.addText(DmServerBundle.message(this.myResourceKey, this.getReferencedModuleName()), mainAttributes);
    }

    public int getWeight() {
        return 20;
    }

    public String getPresentableName() {
        return DmServerBundle.message("WithModulePackagingElementPresentation.presentable.name", this.getReferencedModuleName());
    }

    @NotNull
    private String getReferencedModuleName() {
        String string = this.myModuleId == null ? this.getUnknownModuleName() : this.myModuleId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/WithModulePackagingElementPresentation", "getReferencedModuleName"));
        }
        return string;
    }

    @NotNull
    private String getUnknownModuleName() {
        String string = DmServerBundle.message("WithModulePackagingElementPresentation.undefined.module", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/artifacts/WithModulePackagingElementPresentation", "getUnknownModuleName"));
        }
        return string;
    }
}

