/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.install.impl;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DMServerLibraryFinder {
    @NonNls
    private static final Pattern VERSION_SUFFIX = Pattern.compile("(-|_)\\d+(\\.\\w+)*\\.jar");
    @NonNls
    private static final Pattern SOURCES_SUFFIX = Pattern.compile("sources(-|_)\\d+(\\.\\w+)*\\.jar");

    public List<VirtualFile> getLibraryBundles(VirtualFile folder, boolean filterSources) {
        if (folder == null || !folder.exists()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile next : folder.getChildren()) {
            if (!"jar".equals(next.getExtension()) || this.isSourcesBundle(next) && filterSources) continue;
            result.add(next);
        }
        return result;
    }

    @Nullable
    public VirtualFile getSourcesForLibraryBundle(@NotNull VirtualFile bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/intellij/dmserver/install/impl/DMServerLibraryFinder", "getSourcesForLibraryBundle"));
        }
        VirtualFile parentDir = this.getSourcesContainer(bundle);
        String libraryFilename = bundle.getName();
        int versionStart = libraryFilename.lastIndexOf("-");
        if (versionStart < 0) {
            versionStart = libraryFilename.lastIndexOf("_");
        }
        if (versionStart > 0) {
            String versionSuffix = libraryFilename.substring(versionStart);
            String baseName = libraryFilename.substring(0, versionStart);
            Matcher matcher = VERSION_SUFFIX.matcher(versionSuffix);
            if (matcher.matches()) {
                String minusOrUnderscore = matcher.group(1);
                String sourceFileName = baseName + minusOrUnderscore + "sources" + versionSuffix;
                VirtualFile source = parentDir.findChild(sourceFileName);
                if (source != null) {
                    return source;
                }
            }
        }
        return null;
    }

    public boolean isSourcesBundle(@NotNull VirtualFile jar) {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jar", "com/intellij/dmserver/install/impl/DMServerLibraryFinder", "isSourcesBundle"));
        }
        String name = jar.getName();
        return SOURCES_SUFFIX.matcher(name).find();
    }

    protected VirtualFile getSourcesContainer(VirtualFile bundle) {
        return bundle.getParent();
    }
}

