/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.intention;

import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.dmserver.util.DmServerBundle;
import com.intellij.dmserver.util.ManifestUtils;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.osgi.project.BundleManifest;
import org.jetbrains.osgi.project.BundleManifestCache;
import org.osmorc.manifest.lang.psi.Clause;

public class AddPackageIntentionAction
extends IntentionAndQuickFixAction {
    private final Module myModule;
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRefPointer;
    private final SmartPsiElementPointer<PsiClass> myClassPointer;
    private final LibraryOrderEntry myLibraryEntry;

    public AddPackageIntentionAction(PsiJavaCodeReferenceElement ref, PsiClass clazz, LibraryOrderEntry libraryEntry) {
        this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)ref);
        this.myRefPointer = SmartPointerManager.getInstance((Project)ref.getProject()).createSmartPsiElementPointer((PsiElement)ref);
        this.myClassPointer = SmartPointerManager.getInstance((Project)ref.getProject()).createSmartPsiElementPointer((PsiElement)clazz);
        this.myLibraryEntry = libraryEntry;
    }

    @NotNull
    public String getName() {
        String string = DmServerBundle.message("AddPackageIntentionAction.name", this.getPackageName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/AddPackageIntentionAction", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = DmServerBundle.message("DMServer.QuickFix.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/AddPackageIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, PsiFile file, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/intention/AddPackageIntentionAction", "applyFix"));
        }
        new Fixer(project, editor).fix();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dmserver/intention/AddPackageIntentionAction", "isAvailable"));
        }
        return !project.isDisposed() && !this.myModule.isDisposed() && new Fixer(project, editor).isValid();
    }

    private String getPackageName() {
        return JavaHierarchyUtil.getPackageName((PsiClass)((PsiClass)this.myClassPointer.getElement()));
    }

    private class Fixer {
        private final Project myProject;
        private final Editor myEditor;
        private final ManifestFile myManifestFile;

        public Fixer(Project project, Editor editor) {
            PsiFile source;
            this.myProject = project;
            this.myEditor = editor;
            ManifestFile manifestFile = null;
            BundleManifest manifest = BundleManifestCache.getInstance((Project)project).getManifest(AddPackageIntentionAction.this.myModule);
            if (manifest != null && (source = manifest.getSource()) instanceof ManifestFile) {
                manifestFile = (ManifestFile)source;
            }
            this.myManifestFile = manifestFile;
        }

        public boolean isValid() {
            return this.myManifestFile != null;
        }

        public void fix() {
            if (!this.isValid()) {
                return;
            }
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)AddPackageIntentionAction.this.myRefPointer.getElement();
            PsiClass aClass = (PsiClass)AddPackageIntentionAction.this.myClassPointer.getElement();
            if (ref == null || aClass == null) {
                return;
            }
            Header header = ManifestUtils.getInstance().findHeader((PsiFile)this.myManifestFile, "Import-Package");
            if (header == null) {
                this.myManifestFile.add((PsiElement)ManifestUtils.getInstance().createHeader(this.myProject, "Import-Package", AddPackageIntentionAction.this.getPackageName()));
            } else {
                StringBuilder importPackagesBuilder = new StringBuilder();
                importPackagesBuilder.append(header.getText());
                String ending = "";
                if (importPackagesBuilder.charAt(importPackagesBuilder.length() - 1) == '\n') {
                    ending = "\n";
                    importPackagesBuilder.replace(importPackagesBuilder.length() - 1, importPackagesBuilder.length(), "");
                }
                if (PsiTreeUtil.getChildOfType((PsiElement)header, Clause.class) == null) {
                    if (importPackagesBuilder.charAt(importPackagesBuilder.length() - 1) != ' ') {
                        importPackagesBuilder.append(" ");
                    }
                } else {
                    importPackagesBuilder.append(", ");
                }
                importPackagesBuilder.append(AddPackageIntentionAction.this.getPackageName());
                importPackagesBuilder.append(ending);
                header.replace((PsiElement)ManifestUtils.getInstance().createHeader(this.myProject, importPackagesBuilder));
            }
            OrderEntryUtil.addLibraryToRoots((LibraryOrderEntry)AddPackageIntentionAction.this.myLibraryEntry, (Module)AddPackageIntentionAction.this.myModule);
            if (this.myEditor != null) {
                new AddImportAction(this.myProject, (PsiReference)ref, this.myEditor, new PsiClass[]{aClass}).execute();
            }
        }
    }
}

