/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.dmserver.facet.DMBundleFacet;
import com.intellij.dmserver.intention.AddPackageIntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacet;

public class DmServerUnresolvedReferenceQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement reference, @NotNull QuickFixActionRegistrar registrar) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/dmserver/intention/DmServerUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/dmserver/intention/DmServerUnresolvedReferenceQuickFixProvider", "registerFixes"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)reference);
        if (module == null || OsmorcFacet.getInstance((Module)module) == null || DMBundleFacet.getInstance(module) == null) {
            return;
        }
        this.doRegisterFixes(reference, registrar);
    }

    private void doRegisterFixes(PsiJavaCodeReferenceElement reference, QuickFixActionRegistrar registrar) {
        PsiClass[] classes;
        PsiElement psiElement = reference.getElement();
        String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return;
        }
        if ("TestCase".equals(referenceName) || DmServerUnresolvedReferenceQuickFixProvider.isAnnotation(psiElement) && DmServerUnresolvedReferenceQuickFixProvider.isJunitAnnotationName(referenceName)) {
            return;
        }
        if (DmServerUnresolvedReferenceQuickFixProvider.isAnnotation(psiElement) && AnnotationUtil.isJetbrainsAnnotation((String)referenceName)) {
            return;
        }
        THashSet librariesToAdd = new THashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        for (PsiClass aClass : classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project))) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || moduleFileIndex.getOrderEntryForFile(virtualFile) != null) continue;
                registrar.register((IntentionAction)new AddPackageIntentionAction(reference, aClass, libraryEntry));
            }
        }
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dmserver/intention/DmServerUnresolvedReferenceQuickFixProvider", "getReferenceClass"));
        }
        return PsiJavaCodeReferenceElement.class;
    }

    private static boolean isAnnotation(PsiElement psiElement) {
        return psiElement.getParent() instanceof PsiAnnotation && PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement);
    }

    private static boolean isJunitAnnotationName(@NonNls String referenceName) {
        return "Test".equals(referenceName) || "Ignore".equals(referenceName) || "RunWith".equals(referenceName) || "Before".equals(referenceName) || "BeforeClass".equals(referenceName) || "After".equals(referenceName) || "AfterClass".equals(referenceName);
    }
}

