/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dmserver.libraries.obr;

import com.intellij.dmserver.libraries.ProgressListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRetriever {
    private HttpRetriever() {
    }

    public static String retrievePage(String url) throws IOException {
        return HttpRetriever.retrievePage(url, null);
    }

    public static String retrievePage(String url, @Nullable ProgressListener progressListener) throws IOException {
        return HttpRequests.request((String)url).readString((ProgressIndicator)HttpRetriever.createIndicator(progressListener));
    }

    public static File downloadFile(@NotNull String url, final @NotNull File targetFolder, final @Nullable ProgressListener progressListener) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/dmserver/libraries/obr/HttpRetriever", "downloadFile"));
        }
        if (targetFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFolder", "com/intellij/dmserver/libraries/obr/HttpRetriever", "downloadFile"));
        }
        return (File)HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(){

            public File process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/dmserver/libraries/obr/HttpRetriever$1", "process"));
                }
                String urlPath = request.getConnection().getURL().getPath();
                String targetPath = targetFolder.getAbsolutePath() + File.separatorChar + urlPath.substring(urlPath.lastIndexOf(47) + 1);
                return request.saveToFile(new File(targetPath), (ProgressIndicator)HttpRetriever.createIndicator(progressListener));
            }
        });
    }

    @Nullable
    private static AbstractProgressIndicatorBase createIndicator(final @Nullable ProgressListener progressListener) throws IOException {
        return progressListener == null ? null : new AbstractProgressIndicatorExBase(){

            public void setFraction(double fraction) {
                progressListener.setProgressText((int)(100.0 * fraction + 0.5) + "%");
            }
        };
    }
}

