/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.customizeActions.DissociateResourceBundleAction;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftLazyValue;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousLocalesLanguagesInspection
extends BaseLocalInspectionTool {
    private static final String ADDITIONAL_LANGUAGES_ATTR_NAME = "additionalLanguages";
    private static final SoftLazyValue<Set<String>> JAVA_LOCALES = new SoftLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet result = new HashSet();
            for (Locale locale : Locale.getAvailableLocales()) {
                result.add(locale.getLanguage());
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$1", "compute"));
            }
            return hashSet;
        }
    };
    private final List<String> myAdditionalLanguages = new ArrayList<String>();

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Suspicious resource bundle locale languages" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection", "getDisplayName"));
        }
        return "Suspicious resource bundle locale languages";
    }

    public void setAdditionalLanguages(List<String> additionalLanguages) {
        this.myAdditionalLanguages.clear();
        this.myAdditionalLanguages.addAll(additionalLanguages);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection", "readSettings"));
        }
        String rawLanguages = node.getAttributeValue(ADDITIONAL_LANGUAGES_ATTR_NAME);
        if (rawLanguages != null) {
            this.myAdditionalLanguages.clear();
            this.myAdditionalLanguages.addAll(StringUtil.split((String)rawLanguages, (String)","));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection", "writeSettings"));
        }
        if (!this.myAdditionalLanguages.isEmpty()) {
            ArrayList uniqueLanguages = ContainerUtil.newArrayList((Iterable)ContainerUtil.newHashSet(this.myAdditionalLanguages));
            Collections.sort(uniqueLanguages);
            String locales = StringUtil.join((Collection)uniqueLanguages, (String)",");
            node.setAttribute(ADDITIONAL_LANGUAGES_ATTR_NAME, locales);
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new MyOptions().getComponent();
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection", "checkFile"));
        }
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)file);
        if (propertiesFile == null) {
            return null;
        }
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        List files = resourceBundle.getPropertiesFiles();
        if (!(resourceBundle instanceof ResourceBundleImpl) || files.size() < 2) {
            return null;
        }
        List bundleLocales = ContainerUtil.mapNotNull((Collection)files, propertiesFile1 -> {
            Locale locale = propertiesFile1.getLocale();
            return locale == PropertiesUtil.DEFAULT_LOCALE ? null : locale;
        });
        if ((bundleLocales = ContainerUtil.filter((Collection)bundleLocales, locale -> !((Set)JAVA_LOCALES.getValue()).contains(locale.getLanguage()) && !this.myAdditionalLanguages.contains(locale.getLanguage()))).isEmpty()) {
            return null;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, PropertiesBundle.message((String)"resource.bundle.contains.locales.with.suspicious.locale.languages.desciptor", (Object[])new Object[0]), (LocalQuickFix)new DissociateResourceBundleQuickFix(resourceBundle), ProblemHighlightType.WEAK_WARNING, true);
        return new ProblemDescriptor[]{descriptor};
    }

    private class MyOptions {
        private final JBList myAdditionalLocalesList = new JBList((ListModel)new MyListModel());

        public MyOptions() {
            this.myAdditionalLocalesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
        }

        public JPanel getComponent() {
            final JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)new JLabel(PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.label", (Object[])new Object[0])), "North");
            panel.add((Component)ToolbarDecorator.createDecorator((JList)this.myAdditionalLocalesList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Messages.showInputDialog((Component)panel, (String)PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.input.text", (Object[])new Object[0]), (String)PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.options.input.title", (Object[])new Object[0]), null, (String)"", (InputValidator)new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return 1 < inputString.length() && inputString.length() < 9 && !SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.contains(inputString);
                        }

                        public boolean canClose(String inputString) {
                            if (inputString != null) {
                                SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.add(inputString);
                                ((MyListModel)MyOptions.this.myAdditionalLocalesList.getModel()).fireContentsChanged();
                            }
                            return true;
                        }
                    });
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    int index = MyOptions.this.myAdditionalLocalesList.getSelectedIndex();
                    if (index > -1 && index < SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.size()) {
                        SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.remove(index);
                        ((MyListModel)MyOptions.this.myAdditionalLocalesList.getModel()).fireContentsChanged();
                    }
                }
            }).setPreferredSize(new Dimension(-1, 100)).disableUpDownActions().createPanel(), "Center");
            return panel;
        }

        private class MyListModel
        extends AbstractListModel {
            private MyListModel() {
            }

            @Override
            public int getSize() {
                return SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.size();
            }

            @Override
            public Object getElementAt(int index) {
                return SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.get(index);
            }

            public void fireContentsChanged() {
                this.fireContentsChanged(SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages, -1, -1);
            }
        }
    }

    private static class DissociateResourceBundleQuickFix
    implements LocalQuickFix {
        private final ResourceBundle myResourceBundle;

        private DissociateResourceBundleQuickFix(ResourceBundle bundle) {
            this.myResourceBundle = bundle;
        }

        @NotNull
        public String getFamilyName() {
            String string = PropertiesBundle.message((String)"dissociate.resource.bundle.quick.fix.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix", "getFamilyName"));
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix", "applyFix"));
            }
            DissociateResourceBundleAction.dissociate(Collections.singleton(this.myResourceBundle), (Project)project);
        }
    }
}

